% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctStanGenerate.R
\name{ctStanGenerate}
\alias{ctStanGenerate}
\title{Generate data from a ctstanmodel object}
\usage{
ctStanGenerate(
  cts,
  datastruct = NA,
  is = FALSE,
  fullposterior = TRUE,
  nsamples = 200,
  parsonly = FALSE,
  cores = 2
)
}
\arguments{
\item{cts}{\code{\link{ctStanModel}} , or \code{\link{ctStanFit}},object.}

\item{datastruct}{long format data structure as used by ctsem. 
Not used if ctm is a ctStanFit object.}

\item{is}{If optimizing, follow up with importance sampling?}

\item{fullposterior}{Generate from the full posterior or just the (unconstrained) mean?}

\item{nsamples}{How many samples to generate?}

\item{parsonly}{If TRUE, only return samples of raw parameters, don't generate data.}

\item{cores}{Number of cpu cores to use.}
}
\value{
List contining Y, and array of nsamples by data rows by manifest variables, 
and llrow, an array of nsamples by data rows log likelihoods.
}
\description{
Generate data from a ctstanmodel object
}
\examples{
\donttest{
#generate and plot samples from prior predictive
priorpred <- ctStanGenerate(cts = ctstantestfit,cores=2,nsamples = 50)
}
}
