% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{ctrLoadQueryIntoDbCtgov}
\alias{ctrLoadQueryIntoDbCtgov}
\title{ctrLoadQueryIntoDbCtgov}
\usage{
ctrLoadQueryIntoDbCtgov(queryterm, register, querytoupdate, euctrresults,
  annotation.text, annotation.mode, details, parallelretrievals, debug,
  collection, db, url, username, password, verbose, queryupdateterm)
}
\arguments{
\item{queryterm}{Either a string with the full URL of a search in a register
or the data frame returned by the \link{ctrGetQueryUrlFromBrowser} or the
\link{dbQueryHistory} functions.
The queryterm is recorded in the collection \code{ns} for later use to
update records.}

\item{register}{Vector of abbreviations of registers to query, defaults to
"EUCTR"}

\item{querytoupdate}{Either the word "last" to re-run the last query that
was loaded into the collection, or the integer number of query to be run
again; see \link{dbQueryHistory}. This parameter takes precedence over
\code{queryterm}.}

\item{euctrresults}{If \code{TRUE}, also download available results when
retrieving and loading trials from EUCTR. This slows down this function.
(For CTGOV, all available results are retrieved and loaded from
ctrdata version 0.9.10 onwards.)}

\item{annotation.text}{Text to be including in the records retrieved
with the current query, in the field "annotation".}

\item{annotation.mode}{One of "append" (default), "prepend" or "replace"
for new annotation.text with respect to any existing annotation for
the records retreived with the current query.}

\item{details}{If \code{TRUE} (default), retrieve full protocol-related
information from EUCTR or XML data from CTGOV, depending on the register
selected. This gives all of the available details for the trials.
Alternatively, set to \code{FALSE} to retrieve only summary information
from EUCTR or CSV data from CTGOV. The full EUCTR information includes
separate records for every country in which the trial is opened; use
function \code{dbFindUniqueEuctrRecord} in a subsequent step to limit to
one record from EUCTR per trial}

\item{parallelretrievals}{Number of parallel downloads of information from
the register}

\item{debug}{Printing additional information if set to \code{TRUE}; default
is \code{FALSE}.}

\item{collection}{Name of collection (default is "ctrdata")}

\item{db}{Name of database (default is "users")}

\item{url}{Address of the mongodb server in mongo connection string URI format
\url{http://docs.mongodb.org/manual/reference/connection-string/} (default is
mongodb://localhost)}

\item{username}{In case access requires credentials.}

\item{password}{In case access requires credentials.}

\item{verbose}{Print information.}
}
\description{
ctrLoadQueryIntoDbCtgov
}
\keyword{internal}
