% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_mutations_fragment_size.R
\name{get_mutations_fragment_size}
\alias{get_mutations_fragment_size}
\title{Gets reads fragment lengths for a list of mutations}
\usage{
get_mutations_fragment_size(bam, mutations, tag = "",
  min_base_quality = 20, min_mapq = 30, ...)
}
\arguments{
\item{bam}{path to bam file.}

\item{mutations}{Data frame with mutations. Must have the columns CHROM, POS, REF, ALT.}

\item{tag}{the RG tag if the bam has more than one sample.}

\item{min_base_quality}{minimum base quality when extracting reads covering mutations.}

\item{min_mapq}{minimum mapping quality when extracting reads covering mutations.}

\item{...}{Other parameters passed to get_fragment_size.}
}
\value{
A list with length equal to the number of mutations.
Each element contains a list with two elements ref and alt each having an integer vector of fragment lengths
}
\description{
The function extracts the fragment lengths for the reads holding alternative allele for each mutation
in the mutations data frame.
}
\details{
Fragment length will extracted from the bam file according to the parameters passed to \code{\link{get_fragment_size}},
and the fragment size of the reads that map to the ref and alt alleles of each mutation in the input will be returned.
}
\examples{
\donttest{
data("mutations", package = "ctDNAtools")
bamT1 <- system.file("extdata", "T1.bam", package = "ctDNAtools")

mfs <- get_mutations_fragment_size(bam = bamT1, mutations = mutations[1:2, ])
}
}
\seealso{
\code{\link{get_fragment_size}}
}
