/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.datastore.postgis;

import com.vividsolutions.jump.datastore.AdhocQuery;
import com.vividsolutions.jump.datastore.DataStoreConnection;
import com.vividsolutions.jump.datastore.DataStoreException;
import com.vividsolutions.jump.datastore.DataStoreMetadata;
import com.vividsolutions.jump.datastore.FilterQuery;
import com.vividsolutions.jump.datastore.Query;
import com.vividsolutions.jump.datastore.SpatialReferenceSystemID;
import com.vividsolutions.jump.datastore.postgis.PostgisDSMetadata;
import com.vividsolutions.jump.datastore.postgis.PostgisFeatureInputStream;
import com.vividsolutions.jump.datastore.postgis.PostgisSQLBuilder;
import com.vividsolutions.jump.io.FeatureInputStream;
import java.sql.Connection;
import java.sql.SQLException;

public class PostgisDSConnection
implements DataStoreConnection {
    private PostgisDSMetadata dbMetadata;
    private Connection connection;

    public PostgisDSConnection(Connection conn) {
        this.connection = conn;
        this.dbMetadata = new PostgisDSMetadata(this);
    }

    public Connection getConnection() {
        return this.connection;
    }

    public DataStoreMetadata getMetadata() {
        return this.dbMetadata;
    }

    public FeatureInputStream execute(Query query) {
        if (query instanceof FilterQuery) {
            try {
                return this.executeFilterQuery((FilterQuery)query);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        if (query instanceof AdhocQuery) {
            return this.executeAdhocQuery((AdhocQuery)query);
        }
        throw new IllegalArgumentException("Unsupported Query type");
    }

    public FeatureInputStream executeFilterQuery(FilterQuery query) throws SQLException {
        SpatialReferenceSystemID srid = this.dbMetadata.getSRID(query.getDatasetName(), query.getGeometryAttributeName());
        String[] colNames = this.dbMetadata.getColumnNames(query.getDatasetName());
        PostgisSQLBuilder builder = new PostgisSQLBuilder(srid, colNames);
        String queryString = builder.getSQL(query);
        PostgisFeatureInputStream ifs = new PostgisFeatureInputStream(this.connection, queryString);
        return ifs;
    }

    public FeatureInputStream executeAdhocQuery(AdhocQuery query) {
        String queryString = query.getQuery();
        PostgisFeatureInputStream ifs = new PostgisFeatureInputStream(this.connection, queryString);
        return ifs;
    }

    public void close() throws DataStoreException {
        try {
            this.connection.close();
        }
        catch (Exception ex) {
            throw new DataStoreException(ex);
        }
    }

    public boolean isClosed() throws DataStoreException {
        try {
            return this.connection.isClosed();
        }
        catch (SQLException e) {
            throw new DataStoreException(e);
        }
    }
}

