/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.datastore.jdbc;

import com.vividsolutions.jump.datastore.jdbc.ValueConverter;
import com.vividsolutions.jump.feature.AttributeType;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class ValueConverterFactory {
    public static final ValueConverter DOUBLE_MAPPER = new DoubleConverter();
    public static final ValueConverter INTEGER_MAPPER = new IntegerConverter();
    public static final ValueConverter DATE_MAPPER = new DateConverter();
    public static final ValueConverter STRING_MAPPER = new StringConverter();

    public static ValueConverter getConverter(ResultSetMetaData rsm, int columnIndex) throws SQLException {
        String classname = rsm.getColumnClassName(columnIndex);
        String dbTypeName = rsm.getColumnTypeName(columnIndex);
        int precision = rsm.getPrecision(columnIndex);
        int scale = rsm.getScale(columnIndex);
        int sqlType = rsm.getColumnType(columnIndex);
        if (sqlType == 4 || classname.equalsIgnoreCase("java.lang.Integer") || classname.equalsIgnoreCase("java.math.BigDecimal") && precision == 10 && scale == 0) {
            return INTEGER_MAPPER;
        }
        if (classname.equalsIgnoreCase("java.math.BigDecimal")) {
            return DOUBLE_MAPPER;
        }
        if (classname.equalsIgnoreCase("java.sql.Timestamp")) {
            return DATE_MAPPER;
        }
        if (classname.equalsIgnoreCase("java.String")) {
            return STRING_MAPPER;
        }
        return STRING_MAPPER;
    }

    public static class DateConverter
    implements ValueConverter {
        public AttributeType getType() {
            return AttributeType.DATE;
        }

        public Object getValue(ResultSet rs, int columnIndex) throws SQLException {
            return rs.getDate(columnIndex);
        }
    }

    public static class StringConverter
    implements ValueConverter {
        public AttributeType getType() {
            return AttributeType.STRING;
        }

        public Object getValue(ResultSet rs, int columnIndex) throws SQLException {
            return rs.getString(columnIndex);
        }
    }

    public static class DoubleConverter
    implements ValueConverter {
        public AttributeType getType() {
            return AttributeType.DOUBLE;
        }

        public Object getValue(ResultSet rs, int columnIndex) throws SQLException {
            return new Double(rs.getDouble(columnIndex));
        }
    }

    public static class IntegerConverter
    implements ValueConverter {
        public AttributeType getType() {
            return AttributeType.INTEGER;
        }

        public Object getValue(ResultSet rs, int columnIndex) throws SQLException {
            return new Integer(rs.getInt(columnIndex));
        }
    }
}

