% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_variable_to_data_set.R
\name{add_granularity_geo_to_data_set}
\alias{add_granularity_geo_to_data_set}
\title{Adds granularity_geo to a given data set}
\usage{
add_granularity_geo_to_data_set(x, location_reference = NULL)
}
\arguments{
\item{x}{A data.table containing a column called "location_code".}

\item{location_reference}{A location reference data.table.}
}
\value{
A data.table containing an extra column called "granularity_geo".
}
\description{
Adds granularity_geo to a given data set
}
\examples{
library(data.table)
data <- data.table(location_code = c("norge", "county03", "blah"))
csdata::add_granularity_geo_to_data_set(data)
print(data)

library(data.table)
data <- data.table(location_code = c("norge", "county03", "blah"))
csdata::add_granularity_geo_to_data_set(data, location_reference = csdata::nor_locations_names())
print(data)
}
