% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_donchian.R
\name{donchian_channel}
\alias{donchian_channel}
\title{Add Donchian Channels
to the chart}
\usage{
donchian_channel(
 n = 10,
 include.lag = FALSE,
 color = '#4682b4',
 ...
)
}
\arguments{
\item{n}{Number of periods for moving average.}

\item{include.lag}{Should values be lagged so that today's prices are not
included in the calculation? See Note.}

\item{color}{A \link{character}-vector of \link{length} 1. "#4682b4" by default.}

\item{...}{For internal use. Please ignore.}
}
\value{
An \link{invisible} \code{\link[plotly:plot_ly]{plotly::plot_ly()}}-object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

A high-level \code{\link[plotly:add_lines]{plotly::add_lines()}}-wrapper function that interacts
with the \code{\link[TTR:DonchianChannel]{TTR::DonchianChannel()}}-function.
The function adds Donchian Channels
to the main \code{\link[=chart]{chart()}}.
}
\examples{
# script start;

# Charting BTC using
# candlesticks as main
# chart
cryptoQuotes::chart(
  ticker = BTC,
  main   = cryptoQuotes::kline(),
  sub    = list(
    cryptoQuotes::volume()
  )
)

# script end;
}
\seealso{
Other chart indicators: 
\code{\link{add_event}()},
\code{\link{alma}()},
\code{\link{bollinger_bands}()},
\code{\link{chart}()},
\code{\link{dema}()},
\code{\link{ema}()},
\code{\link{evwma}()},
\code{\link{fgi}()},
\code{\link{hma}()},
\code{\link{lsr}()},
\code{\link{macd}()},
\code{\link{rsi}()},
\code{\link{sma}()},
\code{\link{smi}()},
\code{\link{volume}()},
\code{\link{vwap}()},
\code{\link{wma}()},
\code{\link{zlema}()}

Other main chart indicators: 
\code{\link{add_event}()},
\code{\link{alma}()},
\code{\link{bollinger_bands}()},
\code{\link{dema}()},
\code{\link{ema}()},
\code{\link{evwma}()},
\code{\link{hma}()},
\code{\link{sma}()},
\code{\link{vwap}()},
\code{\link{wma}()},
\code{\link{zlema}()}
}
\author{
Serkan Korkmaz
}
\concept{chart indicators}
\concept{main chart indicators}
