% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crypto_global_markets.R
\name{crypto_global_market}
\alias{crypto_global_market}
\title{Global crypto currency market data}
\usage{
crypto_global_market(market = NULL)
}
\arguments{
\item{market}{Either 'total' or 'altcoin'}
}
\value{
Daily time series of token data in a dataframe:
  \item{timestamp}{Timestamp (POSIXct)}
  \item{market_cap}{Market Cap in USD}
  \item{volume}{Volume traded in USD}
}
\description{
Retrieve daily snapshot of market_cap and the volume traded
for either total crypto currency market or the altcoin market
only. Selecting 'total' will include bitcoin and all altcoins.
}
\note{
The API this uses often will change, please raise an issue on GitHub if errors persist.
}
\examples{
\dontrun{
##
market <- 'total'
crypto_global_market <- crypto_global_market(market)
}
}
