% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new-dataset.R
\name{newDataset}
\alias{newDataset}
\title{Upload data to Crunch to make a new dataset}
\usage{
newDataset(x, name = NULL, ..., project = defaultCrunchProject())
}
\arguments{
\item{x}{a \code{data.frame} or other rectangular R data object, or a string
file name or URL to upload to create a dataset. The file may be a compressed
Zip file containing a single file in CSV or SPSS format.}

\item{name}{character name to give the new Crunch dataset. By default the
function uses the name of the R object, or, if passing a file, the file name.}

\item{...}{additional arguments passed to \code{\link[=createDataset]{createDataset()}}, or \code{schema} if
you're upload Triple-S}

\item{project}{A \code{ProjectFolder} object, string path that could be passed to \code{\link[=cd]{cd()}}
relative to the root project, or a URL for a \code{ProjectFolder}. If left empty,
rcrunch will look in \code{envOrOption('crunch.default.project')} and error if nothing
is found.}
}
\value{
If successful, an object of class CrunchDataset.
}
\description{
This function creates a new dataset on the Crunch server with either a
data.frame or similar object in your R session, a file, or a URL to a file.
It captures available metadata from your R object and translates it into
Crunch types.
}
\details{
If you have an SPSS file, it is better specify the file name directly rather
than first reading it into R. Uploading SPSS files directly to Crunch will
preserve metadata that is stripped by the R import, regardless of the library
used to read it into R.

If you have Triple-S files, you can import those directly to Crunch like you
can with SPSS files. You should use the filename to the data file (ending in
\code{.asc} or \code{.dat}) as the \code{x} argument and use the metadata file (ending in
\code{.sss} or \code{.xml}) as the \code{schema} argument.
}
\examples{
\dontrun{
ds <- newDataset(mtcars, "cars", project = "studies/cars")
ds <- newDataset("mysurvey.sav", project = "https://app.crunch.io/api/projects/abc/")
}
}
\seealso{
\code{\link[=newDatasetFromFile]{newDatasetFromFile()}}; \code{\link[=newDatasetByColumn]{newDatasetByColumn()}} for an alternate
upload method.
}
