% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cube-collapse-dimensions.R
\name{dimSums}
\alias{dimSums}
\title{Collapse an array from a CrunchCube by summing across dimensions to remove}
\usage{
dimSums(x, margin = NULL)
}
\arguments{
\item{x}{the CrunchCube to collapse}

\item{margin}{the margins that should be summed within (in other words: the
dimension that will be retained)}
}
\value{
a duly-collapsed CrunchCube
}
\description{
Typically when collapsing a crosstab you can just sum across the dimensions
that you want to collapse across. However, because we have array-type
questions/dimensions we have to be a little bit smarter. We cannot sum across
any subvariable dimension (dimension types ending with "_items") because that
would inflate the number of respondents by approximately the number of
subvariables. Instead, we take the mean across any "_items" dimension. In
principle, we could just take a single item or \code{unique} across the "_items"
dimensions, however due to floating point differences + rounding there are
minute differences that pop up, \code{mean} smooths over those tiny differences.
}
\details{
\code{dimSums} returns a cube that retains the dimensions given in \code{margin} and
collapses all the others. This is useful if you want to get counts that are
equivalent to a univariate cube from a multivariate cube. For example
\code{dimSums(crtabs(~ fruit + pets, ds), 1)} will be equal to \code{crtabs(~ fruit, ds)} and \code{dimSums(crtabs(~ fruit + pets, ds), 2)} will be equal to \code{crtabs(~ pets, ds)}.
}
\keyword{internal}
