% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monoTestBonf.R
\name{monoTestBonf}
\alias{monoTestBonf}
\title{Monotonicity test using Bonferroni correction}
\usage{
monoTestBonf(simultAlpha = 0.05, OP_UMLE, OP_SE)
}
\arguments{
\item{simultAlpha}{Numerical value for the simultaneous significance level.}

\item{OP_UMLE}{Vector with the unconstrained parameter estimates of an ordinal predictor's categories represented by dummy variables
in an unconstrained model for ordinal response (see \code{\link[VGAM:vglm]{vlgm}}).}

\item{OP_SE}{Vector with the standard error of the parameters of an ordinal predictor's categories represented by dummy variables
in an unconstrained model for ordinal response (see \code{\link[VGAM:vglm]{vlgm}}).}
}
\value{
\code{testRes}: String value with outcomes either "Reject H_0" or "Not Reject H_0".

\code{simultAlpha}: Numerical value with the simultaneous significance level.

\code{indivAlphaA}: Numerical value with the individual significance level for each confidence interval.

\code{simultPvalue}: Numerical value with the p-value associated to the simultaneous significance level.
}
\description{
Tests the null hypothesis of monotonicity over a set of parameters associated to an ordinal predictor.
}
\examples{
monoTestBonf(simultAlpha=0.05, OP_UMLE = c(0.256116, -0.5058427, 1.5799115),
OP_SE = c(0.229569, 0.6948236, 0.4059133))
}
\references{
Espinosa, J., Hennig, C. A constrained regression model for an ordinal response
with ordinal predictors. Stat Comput 29, 869-890 (2019). https://doi.org/10.1007/s11222-018-9842-2.
}
\seealso{
\code{\link[crov:mdcp]{mdcp}}, \code{\link[crov:monoTestConfReg]{monoTestConfReg}}, \code{\link[VGAM:vglm]{vlgm}}.
}
