% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels.R
\name{import_labels}
\alias{import_labels}
\alias{save_labels}
\title{Import labels}
\usage{
import_labels(
  .tbl,
  data_label,
  name_from = "name",
  label_from = "label",
  verbose_name = FALSE,
  verbose_label = FALSE,
  verbose = deprecated()
)

save_labels(.tbl)
}
\arguments{
\item{.tbl}{the data.frame to labellize}

\item{data_label}{a data.frame from which to import labels. If missing, the function will take the labels from the last dataframe on which \code{\link[=save_labels]{save_labels()}} was called.}

\item{name_from}{in \code{data_label}, which column to get the variable name (default to \code{name})}

\item{label_from}{in \code{data_label}, which column to get the variable label (default to \code{label})}

\item{verbose_name}{if TRUE, displays a warning if a variable name is not found in \code{data_label}}

\item{verbose_label}{if TRUE, displays a warning if a label is not found in \code{.tbl}}

\item{verbose}{deprecated}
}
\value{
A dataframe, as \code{.tbl}, with labels

\code{.tbl} invisibly. Used only for its side effects.
}
\description{
\code{import_labels} imports labels from a data.frame (\code{data_label}) to another one (\code{.tbl}). Works in synergy with \code{\link[=save_labels]{save_labels()}}.

\code{save_labels} saves the labels from a data.frame in a temporary variable that can be retrieve by \code{import_labels}.
}
\examples{
#import the labels from a data.frame to another
iris_label = data.frame(
  name=c("Sepal.Length", "Sepal.Width",
         "Petal.Length", "Petal.Width", "Species"),
  label=c("Length of Sepals", "Width of Sepals",
          "Length of Petals", "Width of Petals", "Specie name")
)
iris \%>\% 
  import_labels(iris_label) \%>\% 
  crosstable
  
#save the labels, use some dplyr label-removing function, then retrieve the labels
library(dplyr)
mtcars2 \%>\%
  save_labels() \%>\% 
  transmute(disp=as.numeric(disp)+1) \%>\%
  import_labels(verbose_label=FALSE) \%>\% #
  crosstable(disp)
}
\seealso{
\code{\link[=get_label]{get_label()}}, \code{\link[=set_label]{set_label()}}, \code{\link[=remove_label]{remove_label()}}, \code{\link[=save_labels]{save_labels()}}
}
