% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{read_h}
\alias{read_h}
\title{Read data from a reflections file}
\usage{
read_h(filename)
}
\arguments{
\item{filename}{A character string. Existing file that includes structure 
factors information. The file name in general has the form 
"[prefix]_h.dat".}
}
\value{
A named list with the following elements:
 \itemize{
   \item{a    Real numeric. Unit cell length in angstroms. Always 
              included.}
   \item{SG.   Spacegroup 2-letters character string. There are only two 
               symmetries possible when working within 1D 
               crystallography, P1 (no symmetry) and P-1 (inversion 
               through the origin). SG can be either "P1" or "P-1". 
               Always included.}
   \item{hidx. Real numeric array. 1D unique (positive in the 1D context) 
               Miller indices. Always included.}
   \item{Fobs.      Real numeric array. Amplitudes of observed structure 
                    factors. Not always included.}
   \item{sigFobs.   Real numeric array. Errors associated with Fobs. Not 
                    always included.}
   \item{Fp.        Real numeric vector. Amplitudes of the positive 
                    component of Friedel (or Bijvoet) pairs (F+). Not
                    always included.}
   \item{sigFp.     Real numeric vector. Errors associated with Fp. 
                    Not always included.}
   \item{Fm.        Real numeric vector. Amplitudes of the negative 
                    component of Friedel (or Bijvoet) pairs (F-). Not always
                    included.}
   \item{sigFm.     Real numeric vector. Errors associated with Fm. Not
                    always included.}
   \item{Phiobs.    Real numeric array. Phases (in degrees) of structure 
                    factors obtained with one of the methods used for 
                    structure solution. Not always included.}
   \item{Phicalc.   Real numeric array. Phases (in degrees) of structure 
                    factors calculated from the correct 1D structure. 
                    They are normally used to check correctness of 
                    Phiobs. Not always included.}
         }
}
\description{
Read data from a *_h.dat-type file containing cell size, spacegroup
symbol and amplitudes and/or phases of observed and/or calculated
structure factors. This function loads the file data into a standardised
named list for structure factors data.
}
\examples{
# Observed structure factors amplitudes and calculated phases
# from thiocyanate structure
datadir <- system.file("extdata",package="crone")
filename <- file.path(datadir,"thiocyanate_h.dat")
fdata <- read_x(filename)
print(names(fdata))
print(fdata$Fobs)
print(fdata$sigFobs)

}
