% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model-validity.R
\name{v_model_objects}
\alias{v_model_objects}
\alias{v_general_model}
\alias{v_model_logistic_kadane}
\alias{v_model_logistic_kadane_beta_gamma}
\alias{v_model_logistic_normal_mix}
\alias{v_model_logistic_normal_fixed_mix}
\alias{v_model_logistic_log_normal_mix}
\alias{v_model_dual_endpoint}
\alias{v_model_dual_endpoint_rw}
\alias{v_model_dual_endpoint_beta}
\alias{v_model_dual_endpoint_emax}
\alias{v_model_logistic_indep_beta}
\alias{v_model_eff_log_log}
\alias{v_model_eff_flexi}
\alias{v_model_da_logistic_log_normal}
\alias{v_model_tite_logistic_log_normal}
\alias{v_model_one_par_exp_normal_prior}
\alias{v_model_one_par_exp_prior}
\alias{v_logisticlognormalordinal}
\title{Internal Helper Functions for Validation of \code{\link{GeneralModel}} and \code{\link{ModelPseudo}} Objects}
\usage{
v_general_model(object)

v_model_logistic_kadane(object)

v_model_logistic_kadane_beta_gamma(object)

v_model_logistic_normal_mix(object)

v_model_logistic_normal_fixed_mix(object)

v_model_logistic_log_normal_mix(object)

v_model_dual_endpoint(object)

v_model_dual_endpoint_rw(object)

v_model_dual_endpoint_beta(object)

v_model_dual_endpoint_emax(object)

v_model_logistic_indep_beta(object)

v_model_eff_log_log(object)

v_model_eff_flexi(object)

v_model_da_logistic_log_normal(object)

v_model_tite_logistic_log_normal(object)

v_model_one_par_exp_normal_prior(object)

v_model_one_par_exp_prior(object)

v_logisticlognormalordinal(object)
}
\arguments{
\item{object}{(\code{GeneralModel}) or (\code{ModelPseudo}) \cr object to validate.}
}
\value{
A \code{character} vector with the validation failure messages,
or \code{TRUE} in case validation passes.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

These functions are only used internally to validate the format of an input
\code{\link{GeneralModel}} and \code{\link{ModelPseudo}} or inherited classes and therefore are
not exported.
}
\section{Functions}{
\itemize{
\item \code{v_general_model()}: validates that the names of the
arguments in \code{init} function are included in \code{datanames} or \code{datanames_prior}
slots.

\item \code{v_model_logistic_kadane()}: validates that the logistic Kadane model
parameters are valid.

\item \code{v_model_logistic_kadane_beta_gamma()}: validates that the logistic Kadane model
parameters with a beta and gamma prior are valid.

\item \code{v_model_logistic_normal_mix()}: validates that \code{weightpar} is valid.

\item \code{v_model_logistic_normal_fixed_mix()}: validates that \code{component} is a list with
valid \code{ModelParamsNormal} objects as well as \code{weights} are correct.

\item \code{v_model_logistic_log_normal_mix()}: validates that \code{share_weight} represents probability.

\item \code{v_model_dual_endpoint()}: validates that \code{\link{DualEndpoint}} class slots are valid.

\item \code{v_model_dual_endpoint_rw()}: validates that \code{\link{DualEndpointRW}} class slots are valid.

\item \code{v_model_dual_endpoint_beta()}: validates that \code{\link{DualEndpointBeta}} class slots are valid.

\item \code{v_model_dual_endpoint_emax()}: validates that \code{\link{DualEndpointEmax}} class slots are valid.

\item \code{v_model_logistic_indep_beta()}: validates that \code{\link{LogisticIndepBeta}} class slots are valid.

\item \code{v_model_eff_log_log()}: validates that \code{\link{Effloglog}} class slots are valid.

\item \code{v_model_eff_flexi()}: validates that \code{\link{EffFlexi}} class slots are valid.

\item \code{v_model_da_logistic_log_normal()}: validates that \code{\link{DALogisticLogNormal}} class slots are valid.

\item \code{v_model_tite_logistic_log_normal()}: validates that \code{\link{TITELogisticLogNormal}} class slots are valid.

\item \code{v_model_one_par_exp_normal_prior()}: validates that \code{\link{OneParLogNormalPrior}} class slots are valid.

\item \code{v_model_one_par_exp_prior()}: validates that \code{\link{OneParExpPrior}} class slots are valid.

\item \code{v_logisticlognormalordinal()}: confirms that cov is diagonal

}}
