% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Rules-class.R
\docType{class}
\name{IncrementsRelativeDLT-class}
\alias{.IncrementsRelativeDLT}
\alias{IncrementsRelativeDLT-class}
\title{Increments control based on relative differences in terms of DLTs}
\description{
Note that \code{DLTintervals} is to be read as follows. If for example,
we want to specify three intervals: First 0 DLTs, second 1 or 2 DLTs, and
third at least 3 DLTs, then we specify
\code{DLTintervals} to be \code{c(0, 1, 3)}. That means, the right
bound of the intervals are exclusive to the interval -- the vector only
gives the left bounds of the intervals. The last interval goes from 3 to
infinity.
}
\section{Slots}{

\describe{
\item{\code{DLTintervals}}{an integer vector with the left bounds of the relevant
DLT intervals}

\item{\code{increments}}{a vector of the same length with the maximum allowable
relative increments in the \code{DLTintervals}}
}}
\examples{

# As example, here is the rule for: 
#      maximum doubling the dose if no DLTs were observed at the current dose
#      or maximum increasing the dose by 1.33 if 1 or 2 DLTs were observed at the current dose
#      or maximum increasing the dose by 1.22 if 3 or more DLTs were observed

myIncrements <- IncrementsRelativeDLT(DLTintervals = c(0, 1, 3),
                                      increments = c(1, 0.33, 0.2))

}
\keyword{classes}

