% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_cricsheet.R
\name{fetch_cricsheet}
\alias{fetch_cricsheet}
\title{Fetch ball-by-ball, match and player data from Cricsheet and return a tibble.}
\usage{
fetch_cricsheet(
  type = c("bbb", "match", "player"),
  gender = c("female", "male"),
  competition = "tests"
)
}
\arguments{
\item{type}{Character string giving type of data: ball-by-ball, match info or player info.}

\item{gender}{Character string giving player gender: female or male.}

\item{competition}{Character string giving code corresponding to competition. See \code{\link{cricsheet_codes}} for the
competitions and codes available.}
}
\value{
A \code{tibble} object, similar to a \code{data.frame}.
}
\description{
Download csv data from Cricsheet \url{https://cricsheet.org/downloads/}.
Data must be specified by three factors:
(a) type of data: \code{bbb} (ball-by-ball), \code{match} or \code{player}.
(b) gender;
(c) competition specified as a Cricsheet code. See \code{\link{cricsheet_codes}} for the
competitions and codes available.
}
\examples{
\dontrun{
wbbl_bbb <- fetch_cricsheet(competition = "wbbl", type = "bbb")
wbbl_match <- fetch_cricsheet(competition = "wbbl", type = "match")
wbbl_player <- fetch_cricsheet(competition = "wbbl", type = "player")
}
}
\author{
Jacquie Tran, Hassan Rafique and Rob J Hyndman
}
