% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable_selection.R
\name{xgb_filter}
\alias{xgb_filter}
\title{Select Features using XGB}
\usage{
xgb_filter(
  dat_train,
  dat_test = NULL,
  target = NULL,
  pos_flag = NULL,
  x_list = NULL,
  occur_time = NULL,
  ex_cols = NULL,
  xgb_params = list(nrounds = 100, max_depth = 6, eta = 0.1, min_child_weight = 1,
    subsample = 1, colsample_bytree = 1, gamma = 0, scale_pos_weight = 1,
    early_stopping_rounds = 10, objective = "binary:logistic"),
  f_eval = "auc",
  cv_folds = 1,
  cp = NULL,
  seed = 46,
  vars_name = TRUE,
  note = TRUE,
  save_data = FALSE,
  file_name = NULL,
  dir_path = tempdir(),
  ...
)
}
\arguments{
\item{dat_train}{A data.frame with independent variables and target variable.}

\item{dat_test}{A data.frame of test data. Default is NULL.}

\item{target}{The name of target variable.}

\item{pos_flag}{The value of positive class of target variable, default: "1".}

\item{x_list}{Names of independent variables.}

\item{occur_time}{The name of the variable that represents the time at which each observation takes place.}

\item{ex_cols}{A list of excluded variables. Regular expressions can also be used to match variable names. Default is NULL.}

\item{xgb_params}{Parameters of xgboost.The complete list of parameters is available at: \url{ http://xgboost.readthedocs.io/en/latest/parameter.html}.}

\item{f_eval}{Custimized evaluation function,"ks" & "auc" are available.}

\item{cv_folds}{Number of cross-validations. Default: 5.}

\item{cp}{Threshold of XGB feature's Gain. Default is 1/number of independent variables.}

\item{seed}{Random number seed. Default is 46.}

\item{vars_name}{Logical, output a list of filtered variables or table with detailed IV and PSI value of each variable. Default is FALSE.}

\item{note}{Logical, outputs info. Default is TRUE.}

\item{save_data}{Logical, save results results in locally specified folder. Default is FALSE.}

\item{file_name}{The name for periodically saved results files.  Default is "Feature_importance_XGB".}

\item{dir_path}{The path for periodically saved results files.  Default is "./variable".}

\item{...}{Other parameters to pass to xgb_params.}
}
\value{
Selected variables.
}
\description{
\code{xgb_filter} is for selecting important features using xgboost.
}
\examples{
dat = UCICreditCard[1:1000,c(2,4,8:9,26)]
xgb_params = list(nrounds = 100, max_depth = 6, eta = 0.1,
                                       min_child_weight = 1, subsample = 1,
                                       colsample_bytree = 1, gamma = 0, scale_pos_weight = 1,
                                       early_stopping_rounds = 10,
                                       objective = "binary:logistic")
\dontrun{
xgb_features = xgb_filter(dat_train = dat, dat_test = NULL,
target = "default.payment.next.month", occur_time = "apply_date",f_eval = 'ks',
xgb_params = xgb_params,
cv_folds = 1, ex_cols = "ID$|date$|default.payment.next.month$", vars_name = FALSE)
}
}
\seealso{
\code{\link{psi_iv_filter}}, \code{\link{gbm_filter}}, \code{\link{feature_selector}}
}
