% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_anaylsis.R
\name{get_psi_iv_all}
\alias{get_psi_iv_all}
\alias{get_psi_iv}
\title{Calculate IV & PSI}
\usage{
get_psi_iv_all(dat, dat_test = NULL, x_list = NULL, target,
  ex_cols = NULL, pos_flag = NULL, breaks_list = NULL,
  occur_time = NULL, oot_pct = 0.7, equal_bins = FALSE,
  tree_control = NULL, bins_control = NULL, bins_total = FALSE,
  best = TRUE, g = 10, as_table = TRUE, note = FALSE,
  parallel = FALSE, bins_no = FALSE)

get_psi_iv(dat, dat_test = NULL, x, target, pos_flag = NULL,
  breaks = NULL, breaks_list = NULL, occur_time = NULL,
  oot_pct = 0.7, equal_bins = FALSE, tree_control = NULL,
  bins_control = NULL, bins_total = FALSE, best = TRUE, g = 10,
  as_table = TRUE, note = FALSE, bins_no = FALSE)
}
\arguments{
\item{dat}{A data.frame with independent variables and target variable.}

\item{dat_test}{A data.frame of test data. Default is NULL.}

\item{x_list}{Names of independent variables.}

\item{target}{The name of target variable.}

\item{ex_cols}{A list of excluded variables. Regular expressions can also be used to match variable names. Default is NULL.}

\item{pos_flag}{The value of positive class of target variable, default: "1".}

\item{breaks_list}{A table containing a list of splitting points for each independent variable. Default is NULL.}

\item{occur_time}{The name of the variable that represents the time at which each observation takes place.}

\item{oot_pct}{Percentage of observations retained for overtime test (especially to calculate PSI). Defualt is 0.7}

\item{equal_bins}{Logical, generates initial breaks for equal frequency binning.}

\item{tree_control}{Parameters of using Decision Tree to segment initial breaks. See detials: \code{\link{get_tree_breaks}}}

\item{bins_control}{Parameters  used to control binning.  See detials: \code{\link{select_best_class}}, \code{\link{select_best_breaks}}}

\item{bins_total}{Logical, total sum for each variable.}

\item{best}{Logical, merge initial breaks to get optimal breaks for binning.}

\item{g}{Number of initial breakpoints for equal frequency binning.}

\item{as_table}{Logical, output results in a table. Default is TRUE.}

\item{note}{Logical, outputs info. Default is TRUE.}

\item{parallel}{Logical, parallel computing. Default is FALSE.}

\item{bins_no}{Logical, add serial numbers to bins. Default is FALSE.}

\item{x}{The name of an independent variable.}

\item{breaks}{Splitting points for an independent variable. Default is NULL.}
}
\description{
\code{get_iv_psi}  is used to calculate Information Value (IV)  and Population Stability Index (PSI) of an independent variable.
\code{get_iv_psi_all} can loop through IV & PSI for all specified independent variables.
}
\examples{
iv_list = get_psi_iv_all(dat = UCICreditCard[1:1000, ],
x_list = names(UCICreditCard)[3:5], equal_bins = TRUE,
target = "default.payment.next.month", ex_cols = "ID|apply_date")
get_psi_iv(UCICreditCard, x = "PAY_3",
target = "default.payment.next.month",bins_total = TRUE)
}
\seealso{
\code{\link{get_iv}},\code{\link{get_iv_all}},\code{\link{get_psi}},\code{\link{get_psi_all}}
}
