% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitAndTestCuminc.R
\name{fitCuminc}
\alias{fitCuminc}
\title{Cumulative Incidences Curves}
\usage{
fitCuminc(time, risk, group, cens = NULL)
}
\arguments{
\item{time}{vector with times of the first event or follow-up, must be numeric.}

\item{risk}{vector with type of event, can be numeric or factor/character.}

\item{group}{vector with group variable, can be numeric or factor/character.}

\item{cens}{value of 'risk' indicating censored observation (if NULL, the first value of 'risk' vector will be taken).}
}
\value{
list of length [(number of risks)*(number of groups) + 1], containing estimation of cumulative incidences curves for each risk and group. The last element of a list is a data.frame with results of a K-sample test, containing test statistic, p-value and degrees od freedom for each risk.
}
\description{
Fits cumulative incidence function across different groups and risks.
}
\examples{
fitCuminc(time = LUAD$time, risk = LUAD$event, group = LUAD$gender, cens = "alive")
}
\seealso{
\code{\link[cmprsk]{cuminc}}
}
