# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

cpp_bsplines <- function(x, iknots, bknots, order) {
    .Call('_cpr_cpp_bsplines', PACKAGE = 'cpr', x, iknots, bknots, order)
}

cpp_bsplinesD1 <- function(x, iknots, bknots, order) {
    .Call('_cpr_cpp_bsplinesD1', PACKAGE = 'cpr', x, iknots, bknots, order)
}

cpp_bsplinesD2 <- function(x, iknots, bknots, order) {
    .Call('_cpr_cpp_bsplinesD2', PACKAGE = 'cpr', x, iknots, bknots, order)
}

W <- function(xi_prime, xi, k) {
    .Call('_cpr_W', PACKAGE = 'cpr', xi_prime, xi, k)
}

refine_theta <- function(xi_prime, xi, k, theta) {
    .Call('_cpr_refine_theta', PACKAGE = 'cpr', xi_prime, xi, k, theta)
}

coarsen_theta <- function(j, xi, k, theta) {
    .Call('_cpr_coarsen_theta', PACKAGE = 'cpr', j, xi, k, theta)
}

hat_theta <- function(j, xi, k, theta) {
    .Call('_cpr_hat_theta', PACKAGE = 'cpr', j, xi, k, theta)
}

test_statistic <- function(j, xi, k, theta, Sigma) {
    .Call('_cpr_test_statistic', PACKAGE = 'cpr', j, xi, k, theta, Sigma)
}

#' Rank of a Matrix
#'
#' Determine the rank (number of linearly independent columns) of a matrix.
#'
#' Implementation via the Armadillo C++ linear algebra library.  The function
#' returns the rank of the matrix \code{x}.  The computation is based on the
#' singular value decomposition of the matrix; a std::runtime_error exception
#' will be thrown if the decomposition fails.  Any singular values less than
#' the tolerance are treated as zeros.  The tolerance is
#' \code{max(m, n) * max_sv * arma::datum::eps}, where \code{m} is the number
#' of rows of \code{x}, \code{n} is the number of columns of \code{x},
#' \code{max_sv} is the maximal singular value of \code{x}, and
#' \code{arma::datum::eps} is the difference between 1 and the least value
#' greater than 1 that is representable.
#'
#' @param x a numeric matrix
#'
#' @return
#' the rank of the matrix as a numeric value.
#'
#' @examples
#' # Check the rank of a matrix
#' set.seed(42)
#' mat <- matrix(rnorm(25000 * 120), nrow = 25000)
#' matrix_rank(mat) == ncol(mat)
#' matrix_rank(mat) == 120L
#'
#' # A full rank B-spline basis
#' bmat <- bsplines(seq(0, 1, length = 100), df = 15)
#' matrix_rank(bmat) == 15L
#'
#' # A rank deficient B-spline basis
#' bmat <- bsplines(seq(0, 1, length = 100), iknots = c(0.001, 0.002))
#' ncol(bmat) == 6L
#' matrix_rank(bmat) == 5L
#'
#' @references
#'
#' Conrad Sanderson and Ryan Curtin.  Armadillo: a template-based C++ library
#' for linear algebra.  Journal of Open Source Software, Vol. 1, pp. 26, 2016.
#'
#' @export
matrix_rank <- function(x) {
    .Call('_cpr_matrix_rank', PACKAGE = 'cpr', x)
}

tensor_product <- function(A, B) {
    .Call('_cpr_tensor_product', PACKAGE = 'cpr', A, B)
}

