% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_cp_formula_data.R
\name{generate_cp_formula_data}
\alias{generate_cp_formula_data}
\title{Generate Control Polygon Formula and Data}
\usage{
generate_cp_formula_data(f, .data)
}
\arguments{
\item{f}{a formula}

\item{.data}{the data set containing the variables in the formula}
}
\description{
Construct a \code{data.frame} and \code{formula} to be passed to the
regression modeling tool to generate a control polygon.
}
\details{
This function is expected to be called from within the \code{cpr::cp}
function and is not expected to be called by the end user directly.

\code{generate_cp_data} exists because of the need to build what could be
considered a varying means model.  \code{y ~ bsplines(x1) + x2} will generate
a rank deficient model matrix---the rows of the bspline basis matrix sum to
one with is perfectly collinear with the implicit intercept term.  Specifying
a formula \code{y ~ bsplines(x1) + x2 - 1} would work if \code{x2} is a
continuous variable.  If, however, \code{x2} is a factor, or coerced to a
factor, then the model matrix will again be rank deficient as a column for
all levels of the factor will be generated.  We need to replace the intercept
column of the model matrix with the bspline.  This also needs to be done for
a variety of possible model calls, lm, lmer, etc.

By returning an explicit \code{formula} and \code{data.frame} for use in the
fit, we hope to reduce memory use and increase the speed of the cpr method.
}
\author{
Peter DeWitt \email{dewittpe@gmail.com}
}
