% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/at.R
\name{at}
\alias{at}
\alias{at,CppMap-method}
\alias{at,CppUnorderedMap-method}
\alias{at,CppVector-method}
\alias{at,CppDeque-method}
\title{Access elements with bounds checking}
\usage{
at(x, position)
}
\arguments{
\item{x}{A CppMap, CppUnorderedMap, CppVector, or CppDeque object.}

\item{position}{A key (CppMap, CppUnorderedMap) or index (CppVector, CppDeque).}
}
\value{
Returns the value at the position.
}
\description{
Read a value at a certain position with bounds checking.
}
\details{
In the two associative container types (CppMap, CppUnorderedMap), \code{[]} accesses a value by its key. If the key does not exist, the 
function throws an error.

In the two sequence container types (CppVector, CppDeque), \code{[]} accesses a value by its index. If the index is outside the container, this throws 
an error.

\link{at} and \code{[]} both access elements. Unlike \code{[]}, \link{at} checks the bounds of the container and throws an error, if the element does 
not exist.
}
\examples{
m <- cpp_map(4:6, seq.int(0, 1, by = 0.5))
m
# [4,0] [5,0.5] [6,1]

at(m, 4L)
# [1] 0

d <- cpp_deque(c("hello", "world"))
d
# "hello" "world"

at(d, 2)
# [1] "world"

}
\seealso{
\link{[}, \link{back}, \link{contains}, \link{front}, \link{top}.
}
