% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covablocks.R
\docType{class}
\name{covablocks-class}
\alias{covablocks-class}
\alias{covablocks}
\title{Class "covablocks"}
\usage{
covablocks(stblocks, stpairs, typetest = 0)
}
\arguments{
\item{stblocks}{object of class \code{blocks}}

\item{stpairs}{object of class \code{couples}, containing the spatial
points and the corresponding temporal lags to be analyzed}

\item{typetest}{integer; set \code{typetest=0} for simmetry test (default
choice), \code{typetest=1} for separability test, \code{typetest=2} for type
of non separability test, \code{typetest=3} for the test on the product-sum
class of models, \code{typetest=4} for the test on the integrated product
class of models, \code{typetest=5} for the test on the Gneiting class of
models}
}
\description{
A class for the sample spatio-temporal covariance for each block
of data to be computed for the selected spatial and temporal lags fixed
in \code{stpairs} (output from \code{couples}). Depending on the type of
test the empirical variance, the sample spatial and temporal marginal
covariances for each block of data are also computed. Moreover, the sample
covariances between the spatio-temporal covariances at the specified spatial
and temporal lags are determined.
}
\section{Slots}{

\describe{
\item{\code{mat.cova}}{matrix of sample spatio-temporal covariances for each block,
computed for the spatial and temporal lags given in \code{stpairs}
(object of class \code{couples})}

\item{\code{mat.cova.h}}{matrix of sample spatial marginal covariances
for the specified lags}

\item{\code{mat.cova.u}}{matrix of sample temporal marginal covariances
for the specified lags}

\item{\code{mat.cova.cova}}{matrix of sample covariances between space-time
covariances for each block, computed for the spatial and temporal lags given
in \code{stpairs} (object of class \code{couples})}
}}

\note{
{
\itemize{
\item If \code{typetest} is equal to 0 (simmetry test) or 4 (test on the
integrated product class of models) \code{mat.cova.h} and \code{mat.cova.u}
are not available

\item If \code{typetest} is equal to 5 (test on the Gneiting class of models),
\code{mat.cova.h} is not available

\item If temporal lags in \code{stpairs} are not consistent with block length
(\code{lb}) in \code{stblocks}, an error message will be returned

\item If the proportion between the maximum temporal lag in \code{stpairs} and
the block length (\code{lb}) in \code{stblocks} is greater than 0.25 a warning
message will be returned since the covariance estimation might not be reliable
}
}
}
\examples{
# Before running this function, it is necessary to execute couples and blocks,
# as specified in the examples of the corresponding help pages.
#
# To run the example, paste and copy the following lines
# (without the symbol '#') in the console
#
# coupl_sim <- couples(typetest = 0, typecode = character())
# blocks_sim <- blocks(lb = 40, ls = 10, matdata = rr_13, stpairs = coupl_sim)
# covabl_sim <- covablocks(stblocks = blocks_sim, stpairs = coupl_sim, typetest = 0)


}
\references{
Li, B., Genton, M.G., Sherman, M., 2007, A nonparametric assessment
of properties of spacetime covariance functions.
Journal of the American Statistical Association, \bold{102} 736--744.

De Iaco, S., Palma, M., Posa, D., 2016. A general procedure for selecting a
class of fully symmetric space-time covariance functions.
Environmentrics, \bold{27(4)} 212--224.

Cappello, C., De Iaco, S., Posa, D., 2016, Testing the type of
non-separability and some classes of covariance models for space-time data.
(submitted)
}
\seealso{
\linkS4class{blocks}

\linkS4class{couples}
}
