% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Chaipitak2013.R
\name{Chaipitak2013}
\alias{Chaipitak2013}
\title{Test of Homogeneity of Covariance Matrices given by Chaipitak and Chongcharoen 2013}
\usage{
Chaipitak2013(x, ...)
}
\arguments{
\item{x}{data as a data frame, list of matrices, grouped data frame, or resample object}

\item{...}{other options passed to covTest method}
}
\value{
A list with class "htest" containing the following components:

\tabular{ll}{
\code{statistic} \tab the value of homogeneity of covariance test statistic \cr
\tab \cr
\code{parameter} \tab the degrees of freedom for the chi-squared statistic \cr
\tab \cr
\code{p.value} \tab the p=value for the test \cr
\tab \cr
\code{estimate} \tab the estimated covariances if less than 5 dimensions \cr
\tab \cr
\code{null.value} \tab the specified hypothesized value of the covariance difference \cr
\tab \cr
\code{alternative} \tab a character string describing the alternative hyposthesis \cr
\tab \cr
\code{method} \tab a character string indicating what type of homogeneity of covariance test was performed \cr
\tab \cr
\code{data.name} \tab a character string giving the names of the data
}
}
\description{
Test of Homogeneity of Covariance Matrices given by Chaipitak and Chongcharoen 2013
}
\details{
The \code{\link{homogeneityCovariances}} function is a wrapper function that formats the data 
  for the specific \code{covTest} functions.
}
\examples{
irisSpecies <- unique(iris$Species)

iris_ls <- lapply(irisSpecies, 
    function(x){as.matrix(iris[iris$Species == x, 1:4])}
                 )
                 
names(iris_ls) <- irisSpecies

Chaipitak2013(iris_ls)

}
\references{
Chaipitak, S. and Chongcharoen, S. (2013). A test for 
testing the equality of two covariance matrices for high-dimensional 
data. Journal of Applied Sciences, 13(2):270-277. 
\href{http://doi.org/10.3923/jas.2013.270.277}{10.3923/jas.2013.270.277}
}
