% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_model.R
\name{select_model}
\alias{select_model}
\title{Select the most appropriate model}
\usage{
select_model(fitlist)
}
\arguments{
\item{fitlist}{a list of fits, as created by \code{\link{fit_counts}}.}
}
\value{
a \code{data.frame} with two columns: \code{count}
representing the name of the count and \code{chosen model}
with the model with the lowest BIC.
}
\description{
Select the most appropriate model
}
\examples{
set.seed(1)
df <- data.frame(poisson1 = rpois(50, 2), 
                 poisson2 = rpois(50, 5),
                 zip1 = rZIP(50, 2, 0.7),
                 zip2 = rZIP(50, 5, 0.7))
fitlist_separate <- fit_counts(df, model = c("pois", "zip")) 
select_model(fitlist_separate)
}
