% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corregp.r
\name{ci}
\alias{ci}
\title{Confidence Interval}
\usage{
ci(x, cl = 0.95, nq = TRUE)
}
\arguments{
\item{x}{A numeric vector.}

\item{cl}{The confidence level for the confidence interval. Defaults to \code{0.95}.}

\item{nq}{Logical specifying whether to use a normal quantile (i.e. apply \code{\link[stats]{qnorm}}) in the computation of the confidence interval.
Defaults to \code{TRUE}. If \code{FALSE}, then the confidence interval is computed directly with the \code{\link[stats]{quantile}} function.}
}
\value{
A vector with two components \code{Lower} and \code{Upper} giving the lower and upper confidence limits respectively.
}
\description{
This is the basic function for computing a confidence interval on the basis of a sample of data values.
}
\examples{
\donttest{
data(HairEye)
haireye.crg <- corregp(Eye ~ Hair * Sex, data = HairEye, b = 3000)
ci(haireye.crg$conf$eigen[, 1])
ci(haireye.crg$conf$eigen[, 2])
}
}
\seealso{
\code{\link{ciplot.corregp}}, \code{\link{anova.corregp}}, \code{\link{agplot.corregp}}, \code{\link[stats]{confint}}.
}
