% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_associations.r
\name{tCorpus$feature_associations}
\alias{tCorpus$feature_associations}
\alias{feature_associations}
\title{Get common nearby terms given a feature query}
\arguments{
\item{keyword}{The keyword part of the query, see explanation in \link{tCorpus$search_features}.}

\item{condition}{The condition part of the query, see explanation in \link{tCorpus$search_features}.}

\item{hits}{Alternatively, instead of giving a query, the results of \link{tCorpus$search_features} can be used.}

\item{feature}{If keyword is used, the name of the feature column within which to search.}

\item{window}{The size of the word window (i.e. the number of words next to the feature)}

\item{n}{the top n of associated features}

\item{min_freq}{Optionally, ignore features that occur less than min_freq times}

\item{sort_by}{The value by which to sort the features}

\item{subset}{A call (or character string of a call) as one would normally pass to subset.tCorpus. If given, the keyword has to occur within the subset. This is for instance usefull to only look in named entity POS tags when searching for people or organization. Note that the condition does not have to occur within the subset.}

\item{subset_meta}{A call (or character string of a call) as one would normally pass to the subset_meta parameter of subset.tCorpus. If given, the keyword has to occur within the subset documents. This is for instance usefull to make queries date dependent. For example, in a longitudinal analysis of politicians, it is often required to take changing functions and/or party affiliations into account. This can be accomplished by using subset_meta = "date > xxx & date < xxx" (given that the appropriate date column exists in the meta data).}
}
\description{
Get common nearby terms given a feature query
}
\section{Usage}{

## R6 method for class tCorpus. Use as tc$method (where tc is a tCorpus object).

\preformatted{feature_associations(keyword=NULL, condition=NA, hits=NULL, feature='token',
                                   window=15,  n=25, min_freq=1, sort_by= c('chi2', 'ratio', 'freq'),
                                   subset=NULL, subset_meta=NULL}
}

\examples{
tc = create_tcorpus(sotu_texts, doc_column = 'id')

## directly from query
topf = tc$feature_associations('war')
head(topf, 20) ## frequent words close to "war"

## adjust window size
topf = tc$feature_associations('war', window = 5)
head(topf, 20) ## frequent words very close (five tokens) to "war"

## you can also first perform search_features, to get hits for (complex) queries
hits = tc$search_features('"war terror"~10')
topf = tc$feature_associations(hits = hits)
head(topf, 20) ## frequent words close to the combination of "war" and "terror" within 10 words

}
