% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentation_overview.r
\name{tCorpus_data}
\alias{tCorpus_data}
\title{Methods for viewing, modifying and subsetting tCorpus data}
\description{
\link[=tCorpus]{(back to overview)}
}
\details{
\strong{Get data}
\tabular{ll}{
  \link[=tCorpus$get]{$get()} \tab Get token data, with the possibility to select columns and subset  \cr
  \link[=tCorpus$get]{$get_meta()} \tab Get meta data, with the possibility to select columns and subset  \cr
  \link[=tCorpus$dtm]{$dtm()} \tab Create a document term matrix \cr
  \link[=tCorpus$context]{$context()} \tab Get a context vector. Currently supports documents or globally unique sentences.
}

\strong{Modify}

The token and meta data can be modified with the set* and delete* methods. All modifications are performed by reference.

\tabular{ll}{
  \link[=tCorpus$set]{$set()} \tab Modify the token data by setting the values of one (existing or new) column. \cr
  \link[=tCorpus$set]{$set_meta()} \tab The set method for the document meta data \cr
  \link[=tCorpus$set_levels]{$set_levels()} \tab Change the levels of factor columns. \cr
  \link[=tCorpus$set_meta_levels]{$set_meta_levels()} \tab Change the levels of factor columns in the meta data \cr
  \link[=tCorpus$set_name]{$set_name()} \tab Modify column names of token data. \cr
  \link[=tCorpus$set_meta_name]{$set_meta_name()} \tab Delete columns in the meta data \cr
  \link[=tCorpus$delete_columns]{$delete_columns()} \tab Delete columns.  \cr
  \link[=tCorpus$delete_meta_columns]{$delete_meta_columns()} \tab Delete columns in the meta data
}

Modifying is restricted in certain ways to ensure that the data always meets the assumptions required for tCorpus methods.
tCorpus automatically tests whether assumptions are violated, so you don't have to think about this yourself.
The most important limitations are that you cannot subset or append the data.
For subsetting, you can use the \link{tCorpus$subset} method, and to add data to a tcorpus you can use the \link{merge_tcorpora} function.

\strong{Subsetting, merging/adding}
\tabular{ll}{
  \link[=tCorpus$subset]{$subset()} \tab Modify the token and/or meta data using the \link{tCorpus$subset} function. A subset expression can be specified for both the token data (subset) and the document meta data (subset_meta). \cr
  \link[=tCorpus$subset]{$subset_meta()} \tab For consistency with other *_meta methods \cr
  \link[=tCorpus$subset_query]{$subset_query()} \tab Subset the tCorpus based on a query, as used in \link[=tCorpus$search_contexts]{$search_contexts}
}

\strong{Fields}

For the sake of convenience, the number of rows and column names of the data and meta data.tables can be accessed directly. This is also faster and more memory efficient than using nrows() and colnames() on the data and meta fields, because those have to copy the data.tables.

\tabular{ll}{
  $n \tab The number of tokens (i.e. rows in the data) \cr
  $n_meta \tab The number of documents (i.e. rows in the document meta data) \cr
  $names \tab The names of the token data columns \cr
  $names_meta \tab The names of the document meta data columns
}
}
