% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{coef.cornet}
\alias{coef.cornet}
\title{Extract estimated coefficients}
\usage{
\method{coef}{cornet}(object, ...)
}
\arguments{
\item{object}{\link[cornet]{cornet} object}

\item{...}{further arguments (not applicable)}
}
\value{
This function returns a matrix with \eqn{n} rows and two columns,
where \eqn{n} is the sample size. It includes the estimated coefficients
from linear regression (1st column: \code{"beta"})
and logistic regression (2nd column: \code{"gamma"}).
}
\description{
Extracts estimated coefficients from linear and logistic regression,
under the penalty parameter that minimises the cross-validated loss.
}
\examples{
n <- 100; p <- 200
y <- rnorm(n)
X <- matrix(rnorm(n*p),nrow=n,ncol=p)
net <- cornet(y=y,cutoff=0,X=X)
coef(net)

}
