/*
 * Decompiled with CFR 0.152.
 */
package org.corehunter.data.simple;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.corehunter.data.PhenotypeData;
import org.jamesframework.core.subset.SubsetSolution;
import uno.informatics.common.io.IOUtilities;
import uno.informatics.common.io.RowWriter;
import uno.informatics.data.DataOption;
import uno.informatics.data.Feature;
import uno.informatics.data.Scale;
import uno.informatics.data.SimpleEntity;
import uno.informatics.data.feature.array.ArrayFeatureData;
import uno.informatics.data.io.FileType;

public class SimplePhenotypeData
extends ArrayFeatureData
implements PhenotypeData {
    private static final String ID_HEADER = "X";
    private static final String SELECTED_HEADER = "SELECTED";
    private static final long serialVersionUID = 1L;

    public SimplePhenotypeData(String name, Feature[] features, Object[][] values) {
        super(name, features, values);
    }

    public SimplePhenotypeData(String name, List<? extends Feature> features, List<List<Object>> values) {
        super(name, features, values);
    }

    public SimplePhenotypeData(String name, List<? extends Feature> features, List<SimpleEntity> rowHeaders, List<List<Object>> values) {
        super(name, features, rowHeaders, values);
    }

    public SimplePhenotypeData(String name, List<? extends Feature> features, SimpleEntity[] rowHeaders, Object[][] values) {
        super(name, features, rowHeaders, values);
    }

    public SimplePhenotypeData(String uniqueIdentifier, String name, Feature[] features, Object[][] values) {
        super(uniqueIdentifier, name, features, values);
    }

    public SimplePhenotypeData(String uniqueIdentifier, String name, List<? extends Feature> features, List<List<Object>> values) {
        super(uniqueIdentifier, name, features, values);
    }

    public SimplePhenotypeData(String uniqueIdentifier, String name, List<? extends Feature> features, List<SimpleEntity> rowHeaders, List<List<Object>> values) {
        super(uniqueIdentifier, name, features, rowHeaders, values);
    }

    public SimplePhenotypeData(String uniqueIdentifier, String name, List<? extends Feature> features, SimpleEntity[] rowHeaders, Object[][] values) {
        super(uniqueIdentifier, name, features, rowHeaders, values);
    }

    public SimplePhenotypeData(ArrayFeatureData data) {
        super(data.getUniqueIdentifier(), data.getName(), data.getFeatures(), data.getRowHeaders(), data.getValues());
    }

    public void writeData(Path filePath, FileType fileType, SubsetSolution solution, boolean includeId, boolean includeSelected, boolean includeUnselected) throws IOException {
        if (filePath == null) {
            throw new IllegalArgumentException("File path not defined.");
        }
        if (filePath.toFile().exists()) {
            throw new IOException("File does  exist : " + filePath + ".");
        }
        if (fileType == null) {
            throw new IllegalArgumentException("File type not defined.");
        }
        if (fileType != FileType.TXT && fileType != FileType.CSV) {
            throw new IllegalArgumentException(String.format("Only file types TXT and CSV are supported. Got: %s.", new Object[]{fileType}));
        }
        if (solution == null) {
            throw new NullPointerException("Solution must be defined");
        }
        if (!solution.getAllIDs().equals(this.getIDs())) {
            throw new IllegalArgumentException("Solution ids must match data.");
        }
        if (!includeSelected && !includeUnselected) {
            throw new IllegalArgumentException("One of 'includeSelected' or 'includeUnselected' must be used.");
        }
        Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
        boolean markSelection = includeSelected && includeUnselected;
        try (RowWriter writer = IOUtilities.createRowWriter(filePath, fileType, 3);){
            Set<Integer> includedIDs;
            if (includeId) {
                writer.writeCell(ID_HEADER);
                writer.newColumn();
            }
            writer.writeCell("ID");
            writer.newColumn();
            writer.writeCell("NAME");
            if (markSelection) {
                writer.newColumn();
                writer.writeCell(SELECTED_HEADER);
            }
            for (Feature feature : this.getFeatures()) {
                writer.newColumn();
                writer.writeCell(feature.getUniqueIdentifier());
            }
            writer.newRow();
            if (includeId) {
                writer.newColumn();
            }
            writer.writeCell("NAME");
            writer.newColumn();
            if (markSelection) {
                writer.newColumn();
            }
            for (Feature feature : this.getFeatures()) {
                writer.newColumn();
                writer.writeCell(feature.getName());
            }
            writer.newRow();
            if (includeId) {
                writer.newColumn();
            }
            writer.writeCell("TYPE");
            writer.newColumn();
            if (markSelection) {
                writer.newColumn();
            }
            for (Feature feature : this.getFeatures()) {
                writer.newColumn();
                Scale scale = feature.getMethod().getScale();
                writer.writeCell(scale.getScaleType().getAbbreviation() + scale.getDataType().getAbbreviation());
            }
            writer.newRow();
            if (includeId) {
                writer.newColumn();
            }
            writer.writeCell("MIN");
            writer.newColumn();
            if (markSelection) {
                writer.newColumn();
            }
            for (Feature feature : this.getFeatures()) {
                writer.newColumn();
                writer.writeCell(feature.getMethod().getScale().getMinimumValue());
            }
            writer.newRow();
            if (includeId) {
                writer.newColumn();
            }
            writer.writeCell("MAX");
            writer.newColumn();
            if (markSelection) {
                writer.newColumn();
            }
            for (Feature feature : this.getFeatures()) {
                writer.newColumn();
                writer.writeCell(feature.getMethod().getScale().getMaximumValue());
            }
            if (markSelection) {
                includedIDs = this.getIDs();
            } else if (includeSelected) {
                includedIDs = solution.getSelectedIDs();
            } else if (includeUnselected) {
                includedIDs = solution.getUnselectedIDs();
            } else {
                throw new IllegalArgumentException("One of 'includeSelected' or 'includeUnselected' must be used.");
            }
            ArrayList<Integer> sortedIDs = new ArrayList<Integer>(includedIDs);
            sortedIDs.sort(null);
            Set<Integer> selected = solution.getSelectedIDs();
            Iterator iterator = sortedIDs.iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                writer.newRow();
                if (includeId) {
                    writer.writeCell(id);
                    writer.newColumn();
                }
                SimpleEntity header = this.getHeader(id);
                writer.writeCell(header.getUniqueIdentifier());
                writer.newColumn();
                writer.writeCell(header.getName());
                if (markSelection) {
                    writer.newColumn();
                    writer.writeCell(selected.contains(id));
                }
                writer.newColumn();
                writer.writeRowCells(this.getRow(id).getValues());
            }
        }
    }

    public static final SimplePhenotypeData readPhenotypeData(Path filePath, FileType type, DataOption ... options) throws IOException {
        return new SimplePhenotypeData(ArrayFeatureData.readData(filePath, type, options));
    }
}

