/*
 * Decompiled with CFR 0.152.
 */
package org.jamesframework.core.search.algo;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.jamesframework.core.exceptions.SearchException;
import org.jamesframework.core.factory.MetropolisSearchFactory;
import org.jamesframework.core.problems.Problem;
import org.jamesframework.core.problems.constraints.validations.Validation;
import org.jamesframework.core.problems.objectives.evaluations.Evaluation;
import org.jamesframework.core.problems.sol.Solution;
import org.jamesframework.core.search.Search;
import org.jamesframework.core.search.SingleNeighbourhoodSearch;
import org.jamesframework.core.search.algo.MetropolisSearch;
import org.jamesframework.core.search.listeners.SearchListener;
import org.jamesframework.core.search.neigh.Neighbourhood;

public class ParallelTempering<SolutionType extends Solution>
extends SingleNeighbourhoodSearch<SolutionType> {
    private final List<MetropolisSearch<SolutionType>> replicas;
    private long replicaSteps;
    private final ExecutorService pool;
    private final Queue<Future<Integer>> futures;
    private int swapBase;

    public ParallelTempering(Problem<SolutionType> problem, Neighbourhood<? super SolutionType> neighbourhood, int numReplicas, double minTemperature, double maxTemperature) {
        this(problem, neighbourhood, numReplicas, minTemperature, maxTemperature, (p, n, t) -> new MetropolisSearch(p, n, t));
    }

    public ParallelTempering(Problem<SolutionType> problem, Neighbourhood<? super SolutionType> neighbourhood, int numReplicas, double minTemperature, double maxTemperature, MetropolisSearchFactory<SolutionType> metropolisFactory) {
        this(null, problem, neighbourhood, numReplicas, minTemperature, maxTemperature, metropolisFactory);
    }

    public ParallelTempering(String name, Problem<SolutionType> problem, Neighbourhood<? super SolutionType> neighbourhood, int numReplicas, double minTemperature, double maxTemperature, MetropolisSearchFactory<SolutionType> metropolisFactory) {
        super(name != null ? name : "ParallelTempering", problem, neighbourhood);
        if (numReplicas <= 0) {
            throw new IllegalArgumentException("Error while creating parallel tempering algorithm: number of replicas should be > 0.");
        }
        if (minTemperature <= 0.0) {
            throw new IllegalArgumentException("Error while creating parallel tempering algorithm: minimum temperature should be > 0.0.");
        }
        if (maxTemperature <= 0.0) {
            throw new IllegalArgumentException("Error while creating parallel tempering algorithm: maximum temperature should be > 0.0.");
        }
        if (minTemperature >= maxTemperature) {
            throw new IllegalArgumentException("Error while creating parallel tempering algorithm: minimum temperature should be smaller than maximum temperature.");
        }
        if (metropolisFactory == null) {
            throw new NullPointerException("Error while creating parallel tempering algorithm: metropolis search factory cannot be null.");
        }
        this.replicas = new ArrayList<MetropolisSearch<SolutionType>>();
        for (int i = 0; i < numReplicas; ++i) {
            double temperature = minTemperature + (double)i * (maxTemperature - minTemperature) / (double)(numReplicas - 1);
            MetropolisSearch<? super SolutionType> ms = metropolisFactory.create(problem, neighbourhood, temperature);
            this.replicas.add(ms);
        }
        this.replicaSteps = 500L;
        this.pool = Executors.newFixedThreadPool(numReplicas);
        this.futures = new LinkedList<Future<Integer>>();
        this.swapBase = 0;
        ReplicaListener listener = new ReplicaListener();
        this.replicas.forEach(r -> r.addSearchListener(listener));
    }

    public void setReplicaSteps(long steps) {
        if (steps <= 0L) {
            throw new IllegalArgumentException("Number of replica steps in parallel tempering should be strictly positive.");
        }
        this.replicaSteps = steps;
    }

    public long getReplicaSteps() {
        return this.replicaSteps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNeighbourhood(Neighbourhood<? super SolutionType> neighbourhood) {
        Object object = this.getStatusLock();
        synchronized (object) {
            super.setNeighbourhood(neighbourhood);
            this.replicas.forEach(r -> r.setNeighbourhood(neighbourhood));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCurrentSolution(SolutionType solution) {
        Object object = this.getStatusLock();
        synchronized (object) {
            super.setCurrentSolution(solution);
            this.replicas.forEach(r -> r.setCurrentSolution(Solution.checkedCopy(solution)));
        }
    }

    @Override
    public void init() {
        super.init();
        this.replicas.parallelStream().forEach(Search::init);
    }

    @Override
    protected void searchStep() {
        int i;
        for (i = 0; i < this.replicas.size(); ++i) {
            this.futures.add(this.pool.submit(this.replicas.get(i), i));
        }
        while (!this.futures.isEmpty()) {
            try {
                i = this.futures.poll().get();
                this.incNumAcceptedMoves(this.replicas.get(i).getNumAcceptedMoves());
                this.incNumRejectedMoves(this.replicas.get(i).getNumRejectedMoves());
            }
            catch (InterruptedException | ExecutionException ex) {
                throw new SearchException("An error occured during concurrent execution of Metropolis replicas in the parallel tempering algorithm.", ex);
            }
        }
        for (i = this.swapBase; i < this.replicas.size() - 1; i += 2) {
            MetropolisSearch r1 = this.replicas.get(i);
            MetropolisSearch r2 = this.replicas.get(i + 1);
            double delta = this.computeDelta(r2.getCurrentSolutionEvaluation(), r1.getCurrentSolutionEvaluation());
            boolean swap = false;
            if (delta >= 0.0) {
                swap = true;
            } else {
                double b1 = 1.0 / r1.getTemperature();
                double b2 = 1.0 / r2.getTemperature();
                double diffb = b1 - b2;
                double p = Math.exp(diffb * delta);
                double r = this.getRandom().nextDouble();
                if (r < p) {
                    swap = true;
                }
            }
            if (!swap) continue;
            Object r1Sol = r1.getCurrentSolution();
            Evaluation r1Eval = r1.getCurrentSolutionEvaluation();
            Validation r1Val = r1.getCurrentSolutionValidation();
            r1.setCurrentSolution(r2.getCurrentSolution(), r2.getCurrentSolutionEvaluation(), r2.getCurrentSolutionValidation());
            r2.setCurrentSolution(r1Sol, r1Eval, r1Val);
        }
        this.swapBase = 1 - this.swapBase;
    }

    @Override
    protected void searchDisposed() {
        this.replicas.forEach(r -> r.dispose());
        this.pool.shutdown();
        super.searchDisposed();
    }

    private class ReplicaListener
    implements SearchListener<SolutionType> {
        private ReplicaListener() {
        }

        @Override
        public synchronized void newBestSolution(Search<? extends SolutionType> replica, SolutionType newBestSolution, Evaluation newBestSolutionEvaluation, Validation newBestSolutionValidation) {
            ParallelTempering.this.updateCurrentAndBestSolution(newBestSolution, newBestSolutionEvaluation, newBestSolutionValidation);
        }

        @Override
        public void stepCompleted(Search<? extends SolutionType> replica, long numSteps) {
            if (numSteps >= ParallelTempering.this.replicaSteps) {
                replica.stop();
            }
        }
    }
}

