/*
 * Decompiled with CFR 0.152.
 */
package org.corehunter.objectives;

import java.util.Set;
import org.corehunter.data.CoreHunterData;
import org.corehunter.data.GenotypeData;
import org.corehunter.exceptions.CoreHunterException;
import org.corehunter.objectives.eval.ShannonEvaluation;
import org.jamesframework.core.exceptions.IncompatibleDeltaEvaluationException;
import org.jamesframework.core.problems.objectives.Objective;
import org.jamesframework.core.problems.objectives.evaluations.Evaluation;
import org.jamesframework.core.search.neigh.Move;
import org.jamesframework.core.subset.SubsetSolution;
import org.jamesframework.core.subset.neigh.moves.SubsetMove;

public class Shannon
implements Objective<SubsetSolution, CoreHunterData> {
    public ShannonEvaluation evaluate(SubsetSolution solution, CoreHunterData data) {
        GenotypeData geno = data.getGenotypicData();
        if (geno == null) {
            throw new CoreHunterException("Genotypes are required for Shannon's index.");
        }
        return new ShannonEvaluation(solution.getSelectedIDs(), geno);
    }

    public ShannonEvaluation evaluate(Move move, SubsetSolution curSolution, Evaluation curEvaluation, CoreHunterData data) {
        if (!(move instanceof SubsetMove)) {
            throw new IncompatibleDeltaEvaluationException("Heterozygous loci objective should be used in combination with neighbourhoods that generate moves of type SubsetMove.");
        }
        SubsetMove subsetMove = (SubsetMove)move;
        ShannonEvaluation eval = (ShannonEvaluation)curEvaluation;
        Set<Integer> added = subsetMove.getAddedIDs();
        Set<Integer> deleted = subsetMove.getDeletedIDs();
        return new ShannonEvaluation(eval, added, deleted, data.getGenotypicData());
    }

    @Override
    public boolean isMinimizing() {
        return false;
    }

    public String toString() {
        return "Shannon";
    }
}

