% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeframe.R
\name{makeframe}
\alias{makeframe}
\title{Display a single movie frame}
\usage{
makeframe(
  frame.draw,
  frame.index,
  width = 1080,
  height = 720,
  keep.frame = FALSE
)
}
\arguments{
\item{frame.draw}{function that plots an individual frame. This function must have exactly one  argument 'x', which can be integer (e.g. a simple frame index) or real (e.g. a time).}

\item{frame.index}{list of frame indices 'x' to be included in the movie}

\item{width}{number of pixels along the horizontal axis}

\item{height}{number of pixels along the vertical axis}

\item{keep.frame}{logical flag specifying whether to keep the temporary png-file of the frame}
}
\value{
None
}
\description{
Displays a single movie-frame in the R-console, exactly as used in a movie generated with \code{\link{makemovie}}.
}
\examples{

## Example: Movie of a manual clock

# Function to draw a single clock face with two hands
frame = function(time) {
  par(mar=c(0,0,0,0))
  nplot(xlim=c(-1.1,1.1),ylim=c(-1.1,1.1),pty='s')
  plotrix::draw.circle(0,0,1,col='#aaaaff')
  radius = c(0.5,0.9)
  speed = 2*pi/c(720,60)
  lwd = c(4,2)
  graphics::arrows(0,0,radius*sin(speed*time),radius*cos(speed*time),lwd=lwd)
}

# Produce movie
\dontrun{
makeframe(frame,15,200,200)
}

}
\seealso{
\code{\link{makemovie}}
}
\author{
Danail Obreschkow
}
