% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_prep.R
\name{.javascript_attributes}
\alias{.javascript_attributes}
\title{Prepare cookie attributes for javascript}
\usage{
.javascript_attributes(expiration, secure_only, domain, path, same_site)
}
\arguments{
\item{expiration}{Days after which the cookie should expire. To remove an
HttpOnly cookie, send a negative value for this attribute.}

\item{secure_only}{Logical indicating whether the cookie should only be
accessible via secure (\verb{https:}) requests (except on localhost).}

\item{domain}{The host to which the cookie will be sent (including
subdomains). If this is \code{NULL} (default) the cookie will only be sent to
the host of the page where this cookie was set (not including subdomains).}

\item{path}{The path that must exist in the requested URL for the browser to
send this cookie. Includes subdirectories.}

\item{same_site}{One of "strict", "lax" (default), or "none", indicating when
the cookie should be sent. When \code{same_site = "none"}, \code{secure_only} must be
\code{TRUE}.}
}
\value{
A list of attributes with the names expected by js-cookie.
}
\description{
Prepare cookie attributes for javascript
}
\keyword{internal}
