% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0-DictR6.R
\name{Dict}
\alias{Dict}
\title{Dict Class}
\description{
The \code{\link[=Dict]{Dict()}} resembles Python's dict type, and is implemented
as a specialized associative \code{\link[=Container]{Container()}}.
For the standard S3 interface, see \link[=Dict]{dict()}.
}
\details{
This class inherits from class \code{\link[=Container]{Container()}} and overwrides some
methods to account for the associative key-value pair semantic.
Internally, all key-value pairs are stored in a hash-table and the
elements are always sorted lexicographically by their keys.
}
\examples{
d = Dict$new(o = "one", na = NA, a = 1)
d
d$keys()

d$add("li", list(1, 2))
d$discard_at("na")
d$replace(1, 9)

d2 = Dict$new(a = 0, b = 1)
d$update(d2)
}
\seealso{
\code{\link[=Container]{Container()}}, \code{\link[=dict]{dict()}}
}
\section{Super classes}{
\code{\link[container:Iterable]{container::Iterable}} -> \code{\link[container:Container]{container::Container}} -> \code{Dict}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Dict$new()}}
\item \href{#method-add}{\code{Dict$add()}}
\item \href{#method-discard_at}{\code{Dict$discard_at()}}
\item \href{#method-get}{\code{Dict$get()}}
\item \href{#method-keys}{\code{Dict$keys()}}
\item \href{#method-remove}{\code{Dict$remove()}}
\item \href{#method-replace}{\code{Dict$replace()}}
\item \href{#method-set}{\code{Dict$set()}}
\item \href{#method-sort}{\code{Dict$sort()}}
\item \href{#method-update}{\code{Dict$update()}}
\item \href{#method-values}{\code{Dict$values()}}
\item \href{#method-clone}{\code{Dict$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Iterable" data-id="iter">}\href{../../container/html/Iterable.html#method-iter}{\code{container::Iterable$iter()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="at">}\href{../../container/html/Container.html#method-at}{\code{container::Container$at()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="at2">}\href{../../container/html/Container.html#method-at2}{\code{container::Container$at2()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="clear">}\href{../../container/html/Container.html#method-clear}{\code{container::Container$clear()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="count">}\href{../../container/html/Container.html#method-count}{\code{container::Container$count()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="delete">}\href{../../container/html/Container.html#method-delete}{\code{container::Container$delete()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="delete_at">}\href{../../container/html/Container.html#method-delete_at}{\code{container::Container$delete_at()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="discard">}\href{../../container/html/Container.html#method-discard}{\code{container::Container$discard()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="empty">}\href{../../container/html/Container.html#method-empty}{\code{container::Container$empty()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="get_compare_fun">}\href{../../container/html/Container.html#method-get_compare_fun}{\code{container::Container$get_compare_fun()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="has">}\href{../../container/html/Container.html#method-has}{\code{container::Container$has()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="has_name">}\href{../../container/html/Container.html#method-has_name}{\code{container::Container$has_name()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="is_empty">}\href{../../container/html/Container.html#method-is_empty}{\code{container::Container$is_empty()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="length">}\href{../../container/html/Container.html#method-length}{\code{container::Container$length()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="names">}\href{../../container/html/Container.html#method-names}{\code{container::Container$names()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="peek_at">}\href{../../container/html/Container.html#method-peek_at}{\code{container::Container$peek_at()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="peek_at2">}\href{../../container/html/Container.html#method-peek_at2}{\code{container::Container$peek_at2()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="pop">}\href{../../container/html/Container.html#method-pop}{\code{container::Container$pop()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="print">}\href{../../container/html/Container.html#method-print}{\code{container::Container$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="rename">}\href{../../container/html/Container.html#method-rename}{\code{container::Container$rename()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="replace_at">}\href{../../container/html/Container.html#method-replace_at}{\code{container::Container$replace_at()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="size">}\href{../../container/html/Container.html#method-size}{\code{container::Container$size()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="type">}\href{../../container/html/Container.html#method-type}{\code{container::Container$type()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\code{Dict} constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Dict$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{initial elements put into the \code{Dict}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
returns the \code{Dict}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add"></a>}}
\if{latex}{\out{\hypertarget{method-add}{}}}
\subsection{Method \code{add()}}{
If \code{name} not yet in \code{Dict}, insert \code{value} at \code{name},
otherwise signal an error.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Dict$add(name, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{\code{character} variable name under which to store \code{value}.}

\item{\code{value}}{the value to be added to the \code{Dict}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the \code{Dict} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-discard_at"></a>}}
\if{latex}{\out{\hypertarget{method-discard_at}{}}}
\subsection{Method \code{discard_at()}}{
Discard value at given index. If index is not found,
the operation is ignored.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Dict$discard_at(index)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index}}{\code{character} or \code{numeric} index}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the \code{Dict} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get"></a>}}
\if{latex}{\out{\hypertarget{method-get}{}}}
\subsection{Method \code{get()}}{
This function is deprecated. Use \code{\link[=at2]{at2()}} instead.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Dict$get(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{\code{character} name of key.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
If \code{key} in \code{Dict}, return value at \code{key}, else throw error.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-keys"></a>}}
\if{latex}{\out{\hypertarget{method-keys}{}}}
\subsection{Method \code{keys()}}{
Get all keys.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Dict$keys()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{character} vector of all keys.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-remove"></a>}}
\if{latex}{\out{\hypertarget{method-remove}{}}}
\subsection{Method \code{remove()}}{
This function is deprecated. Use \code{\link[=delete]{delete()}} instead.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Dict$remove(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{\code{character} name of key.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
If \code{key} in \code{Dict}, remove it, otherwise raise an error.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-replace"></a>}}
\if{latex}{\out{\hypertarget{method-replace}{}}}
\subsection{Method \code{replace()}}{
Replace one element by another element.
Search for occurence of \code{old} and, if found, replace it by \code{new}.
If \code{old} does not exist, an error is signaled.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Dict$replace(old, new)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{old}}{element to be replaced}

\item{\code{new}}{element to be put instead of old}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the \code{Dict} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set"></a>}}
\if{latex}{\out{\hypertarget{method-set}{}}}
\subsection{Method \code{set()}}{
This function is deprecated. Use \code{\link[=replace]{replace()}} instead.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Dict$set(key, value, add = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{\code{character} name of key.}

\item{\code{value}}{the value to be set}

\item{\code{add}}{\code{logical} if \code{TRUE} the value is set regardless whether
\code{key} already exists in \code{Dict}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
returns the \code{Dict}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sort"></a>}}
\if{latex}{\out{\hypertarget{method-sort}{}}}
\subsection{Method \code{sort()}}{
Sort elements according to their keys. This function
is deprecated as keys are now always sorted.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Dict$sort(decr = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{decr}}{\code{logical} if \code{TRUE} sort in decreasing order.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
returns the \code{Dict}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update"></a>}}
\if{latex}{\out{\hypertarget{method-update}{}}}
\subsection{Method \code{update()}}{
Add elements of \code{other} to this if the name is
not in the \code{Dict} and update elements with existing names.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Dict$update(other)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{other}}{\code{Iterable} object used to update this.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
returns the updated \code{Dict} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-values"></a>}}
\if{latex}{\out{\hypertarget{method-values}{}}}
\subsection{Method \code{values()}}{
Get \code{Container} values
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Dict$values()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a copy of all elements in a list
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Dict$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
