% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tempAggregate.R
\name{tempAggregate}
\alias{tempAggregate}
\title{Smooth Point-Locations Over Time}
\usage{
tempAggregate(
  x = NULL,
  id = NULL,
  point.x = NULL,
  point.y = NULL,
  dateTime = NULL,
  secondAgg = 10,
  extrapolate.left = FALSE,
  extrapolate.right = FALSE,
  resolutionLevel = "full",
  parallel = FALSE,
  nCores = (parallel::detectCores()/2),
  na.rm = TRUE,
  smooth.type = 1
)
}
\arguments{
\item{x}{Data frame or list of data frames containing real-time-location 
data.}

\item{id}{Vector of length nrow(data.frame(x)) or singular character data, 
detailing the relevant colname in x, that denotes what unique ids for 
tracked individuals will be used. If argument == NULL, the function 
assumes a column with the colname "id" exists in x. Defaults to NULL.}

\item{point.x}{Vector of length nrow(data.frame(x)) or singular character 
data, detailing the relevant colname in x, that denotes what planar-x or 
longitude coordinate information will be used. If argument == NULL, the 
function assumes a column with the colname "x" exists in x. Defaults to 
NULL.}

\item{point.y}{Vector of length nrow(data.frame(x)) or singular character 
data, detailing the relevant colname in x, that denotes what planar-y or 
lattitude coordinate information will be used. If argument == NULL, the 
function assumes a column with the colname "y" exists in x. Defaults to 
NULL.}

\item{dateTime}{Vector of length nrow(data.frame(x)) or singular character 
data, detailing the relevant colname in x, that denotes what dateTime 
information will be used. If argument == NULL, the function assumes a 
column with the colname "dateTime" exists in x. Defaults to NULL.}

\item{secondAgg}{Numerical. The number of seconds over which 
tracked-individuals' location will be averaged. Defaults to 10.}

\item{extrapolate.left}{Logical. If TRUE, individuals position at time 
points prior to their first location fix will revert to their first 
recorded location. If FALSE, NAs will be placed at these time points in 
individuals' movement paths. Defaults to FALSE.}

\item{extrapolate.right}{Logical. If TRUE, individuals position at time 
points following their last location fix will revert to their final 
recorded location. If FALSE, NAs will be placed at these time points in 
individuals' movement paths. Defaults to FALSE.}

\item{resolutionLevel}{Character string taking the value of "full" or 
"reduced."  If "full," if no known locations of individuals exist over 
any secondAgg time block, xy-coordinates revert to the last-known values 
for that individual. If "reduced," if no known locations of individuals 
exist over any secondAgg time block, NAs will be produced for the time 
blocks of interest. Defaults to "full."}

\item{parallel}{Logical. If TRUE, sub-functions within the tempAggregate 
wrapper will be parallelized. Defaults to FALSE.}

\item{nCores}{Integer. Describes the number of cores to be dedicated to 
parallel processes. Defaults to half of the maximum number of cores 
available (i.e., (parallel::detectCores()/2)).}

\item{na.rm}{Logical. If TRUE, all unknown locations (i.e., xy-coordinate 
pairs reported as NAs) will be removed from the output. Defaults to TRUE.
Note that if na.rm == FALSE, all aggregated location fixes will be 
temporally equidistant.}

\item{smooth.type}{Numerical, taking the values 1 or 2. Indicates the type 
of smooting used to average individuals' xy-coordinates. If 
smooth.type == 1, data are smoothed forwards. If smooth.type == 2, data 
are smoothed backwards. Defaults to 1.}
}
\value{
Returns a data frame (or list of data frames if \code{x} is a 
   list of data frames) with the following columns:
   
   \item{id}{The unique ID of tracked individuals.}
   \item{x}{Smoothed x coordinates.}
   \item{y}{Smoothed y coordinates.}
   \item{dateTime}{Timepoint at which smoothed points were observed.}
}
\description{
Aggregate location data by secondAgg seconds over the course of each day 
   represented in the dataset. The function smooths xy data forwards 
   (smooth.type == 1) or backwards (smooth.type == 2) according to a 
   data-point-averaging loess smoothing methodology. As part of the 
   smoothing process, tempAggregate fills in any missing values (either due 
   to a lack of data transmission or faulty prior interpolation). We 
   recognize that this procedure is not sensitive to individual presence at 
   given timesteps (e.g., some individuals may be missing on certain days, 
   hours, etc., and therefore may produce inaccurate location aggregates if 
   days/hours exist where individuals are not present in the dataset (e.g., 
   they were purposefully removed, or moved outside of the monitoring 
   area)). To increase accuracy, package users may specify a resolutionLevel
   ("full" or "reduced") to process individuals' locations at different 
   resolutions. If resolution == "reduced", if no locations of individuals 
   exist over any secondAgg time block, NAs will be produced for the time 
   blocks of interest. 
   
This function is based on real-time-location-data-smoothing methods 
   presented by Dawson et al. 2019.
}
\examples{
data("calves")
head(calves) #observe that fix intervals occur ever 4-5 seconds.

calves.dateTime<-datetime.append(calves, date = calves$date, 
   time = calves$time) #add dateTime identifiers for location fixes.
   
calves.agg<-tempAggregate(calves.dateTime, id = calves.dateTime$calftag, 
   dateTime = calves.dateTime$dateTime, point.x = calves.dateTime$x, 
   point.y = calves.dateTime$y, secondAgg = 300, extrapolate.left = FALSE, 
   extrapolate.right = FALSE, resolutionLevel = "reduced", parallel = FALSE, 
   na.rm = TRUE, smooth.type = 1) #smooth to 5-min fix intervals.
   
}
\references{
Dawson, D.E., Farthing, T.S., Sanderson, M.W., and Lanzas, C. 
   2019. Transmission on empirical dynamic contact networks is influenced by
   data processing decisions. Epidemics 26:32-42. 
   https://doi.org/10.1016/j.epidem.2018.08.003/
}
\keyword{data-processing}
\keyword{location}
\keyword{point}
\keyword{smoothing}
