% 2023-12-15 Andreas Papritz revision and incorporation of description of
% covariance models taken from help page of function CovarianceFct of
% package RandomFields version 2.0.71
% R CMD Rdconv -t html -o bla.html covmodel.Rd ; open bla.html;
% R CMD Rd2pdf --force covmodel.Rd;


\name{covmodel}
\alias{covmodel}
\alias{covmodellist}
\alias{print.covmodel}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Create isotropic covariance model
}

\description{Function to generate isotropic covariance models, or add an
isotropic covariance model to an existing isotropic model.}

\usage{
covmodel(modelname, mev, nugget,variance, scale, parameter, add.covmodel)

\S3method{print}{covmodel}(x, \ldots)
}

\arguments{

  \item{modelname}{a character scalar with the name of an isotropic
  covariance model, see \emph{Details} for a list of implemented models.  A
  call of \code{covmodel()} without any function argument displays a table
  with all available models and their parameters, see \emph{Examples}.}

  \item{mev}{a numeric scalar, variance of the measurement error.}

  \item{nugget}{a numeric scalar, variance of microstructure white noise
  process with range smaller than the minimal distance between any
  pair of support data.}

  \item{variance}{a numeric scalar, partial sill of the covariance model.}

  \item{scale}{a numeric scalar, scale ("range") parameter of the covariance
  model.}

  \item{parameter}{a numeric vector of further covariance parameters, missing
  for some model like \code{nugget}, \code{spherical} or \code{gauss}, etc,
  see \emph{Details}.  If a model has several extra parameters, say
  \code{a}, \code{b}, ...  then they must be given as \code{c(a, b, ...)}.
  }

  \item{add.covmodel}{an object of the class \code{covmodel} that is added to
  the covariance model defined by \code{modelname} (see examples)}

  \item{x}{a covariance model generated by \code{covmodel}}

  \item{\ldots}{further printing arguments}

}

\details{

  The name and parametrisation of the covariance models originate from the
  function \code{CovarianceFct} of the archived package \pkg{RandomFields},
  version 2.0.71.

  The following isotropic covariance functions are implemented (equations
  taken from help page of function \code{CovarianceFct} of archived package
  \pkg{RandomFields}, version 2.0.71, note that the variance and range
  parameters are equal to 1 in the following formulae and \eqn{h} is the
  lag distance.):

  \itemize{

    \item \code{bessel}
    \deqn{C(h)=2^a \Gamma(a+1)h^{-a} J_a(h)}
    For a 2-dimensional region, the parameter \eqn{a} must be greater than
    or equal to 0.

    \item \code{cauchy}
    \deqn{C(h)=\left(1+h^2\right)^{-a}}{C(h)=(1+h^2)^(-a)}
    The parameter \eqn{a} must be positive.

    \item \code{cauchytbm}
    \deqn{C(h)= (1+(1-b/3)h^a)(1+h^a)^{(-b/a-1)}}
    The parameter \eqn{a} must be in (0,2] and  \eqn{b}
    positive.
    The model is valid for 3 dimensions.
    It allows for simulating random fields where
    fractal dimension and Hurst coefficient can be chosen
    independently.

    \item \code{circular}
    \deqn{C(h)=
      \left(1-\frac 2\pi
      \left(h \sqrt{1-h^2} +
      \arcsin(h)\right)\right)
      1_{[0,1]}(h)}{
      C(h)=1-2/pi*(h sqrt(1-h^2)+asin(h))   if
      0<=h<=1, 0 otherwise}
    This isotropic covariance function is valid only for dimensions
    less than or equal to 2.

    \item \code{constant}
    \deqn{C(h)=1}

    \item \code{cubic}
    \deqn{C(h)=(1- 7h^2+8.75h^3-3.5h^5+0.75 h^7)1_{[0,1]}(h)}{C(h)=
      1- 7 h^2 + 8.75 h^3 - 3.5 h^5 + 0.75 h^7  if 0<=h<=1,
      0 otherwise}
    This model is valid only for dimensions less than or equal to 3.
    It is a 2 times differentiable covariance functions with compact
    support.

    \item \code{dampedcosine} (hole effect model)
    \deqn{C(h)= e^{-a h} \cos(h)}
    This model is valid for 2 dimensions iff \eqn{a \ge 1}.

    \item \code{exponential}
    \deqn{C(h)=e^{-h}}
    This model is a special case of the \code{whittle} model
    (for \eqn{a=0.5})
    and the \code{stable} model (for \eqn{a = 1}).

    \item \code{gauss}
    \deqn{C(h)=e^{-h^2}}{C(h)=exp(-h^2)}
    This model is a special case of the \code{stable} model
    (for \eqn{a=2}).
    See \code{gneiting} for an alternative model that does not have
    the disadvantages of the Gaussian model.

    \item \code{gencauchy} (generalised \code{cauchy})
    \deqn{C(h)= \left(1+h^a\right)^{(-b/a)}}{C(h)= (1+h^a)^{(-b/a)}}
    The parameter \eqn{a} must be in (0,2] and \eqn{b}
    positive.
    This model allows for random fields where
    fractal dimension and Hurst coefficient can be chosen
    independently.

    \item \code{gengneiting} (generalised \code{gneiting})
    If \eqn{a=1} and let \eqn{\beta = b+1} then
    \deqn{C(h)=\left(1+\beta h\right) (1-h)^{\beta}
      1_{[0,1]}(h)}{C(h)=(1+\beta h) (1-h)^{\beta}
      1_{[0,1]}(h)}
    If \eqn{a=2}  and let \eqn{\beta = b+2} then
    \deqn{C(h)=\left(1+\beta h+\left(\beta ^2-1\right)h^2/3\right)
      (1-h)^{\beta}  1_{[0,1]}(h)}{C(h)=(1+\beta h+(\beta ^2-1)h^2/3)
      (1-h)^{\beta}  1_{[0,1]}(h)}
    If \eqn{a=3}   and let \eqn{\beta = b+3} then
    \deqn{C(h)=\left(1+\beta h+\left(2\beta ^2-3\right)\frac{h^2}{5}
      +\left(\beta ^2-4\right)\beta \frac{h^3}{15}\right)(1-h)^{\beta}
      1_{[0,1]}(h)}{C(h)=(1+\beta h+(2\beta ^2-3)h^2/5
      +(\beta ^2-4)\beta h^3/15)(1-h)^{\beta}
      1_{[0,1]}(h)}
    The parameter \eqn{a} is a positive integer; here only the
    cases \eqn{a=1, 2, 3} are implemented.
    For two dimensional regions the parameter \eqn{b} must greater than or equal to
    \eqn{(2 + 2a +1)/2}.

   \item \code{gneiting}
    \deqn{C(h)=\left(1 + 8 sh + 25 (sh)^2 + 32
      (sh)^3\right)(1-sh)^8 1_{[0,1]}(sh)}{C(h)=
      (1 + 8 s h + 25 s^2 h^2 + 32
      s^3 h^3)*(1-s h)^8   if 0 <= h <= 1/s, 0 otherwise}
    where
    \eqn{s=0.301187465825}.
    This  covariance function is valid only for dimensions less
    than or equal to 3.
    It is a 6 times differentiable covariance functions with compact
    support.
    It is an alternative to the \code{gaussian} model since
    its graph is visually hardly distinguishable from the graph of
    the Gaussian model, but possesses neither the mathematical and nor the
    numerical disadvantages of the Gaussian model.

    \item \code{hyperbolic}
    \deqn{C(h)= c^{-b}(K_{b}(a c))^{-1}
      ( c^2 + h^2 )^{b/2}
      K_{b}(
      a [ c^2 + h^2 ]^{1/2} )}
    The parameters are such that\cr
    \eqn{c\ge0},  \eqn{a>0}  and
    \eqn{b>0,\quad}{b>0, }
    or\cr
    \eqn{c>0},  \eqn{a>0}  and  \eqn{b=0,\quad}{b>0, }
    or\cr
    \eqn{c>0},  \eqn{a\ge0}, and   \eqn{b<0}.\cr
    Note that this class is over-parametrised; always one
    of the three parameters
    \eqn{a}, \eqn{c}, and scale
    can be eliminated in the formula.

    \item \code{lgd1} (local-global distinguisher)
    \deqn{C(h)=
      1-\frac{\beta}{a+b}|h|^{a}, |h|\le 1 \qquad \hbox{and} \qquad
      \frac{a}{a+b}|h|^{-b}, |h|> 1
    }{C(h)=
      1-b^{-1}{a+b}|h|^{a}, |h|\le 1    and
      a^{-1}{a+b}|h|^{-b}, |h|> 1
    }
    Here \eqn{b>0} and \eqn{a} msut be in
    \eqn{(0,0.5]}.
    The random field has for 2-dimensional regions fractal dimension
    \eqn{3 - a/2}
    and Hurst coefficient \eqn{1 -b/2} for
    \eqn{b \in (0,1]}

    \item \code{matern}
    \deqn{C(h)= 2^{1-a} \Gamma(a)^{-1}
       (\sqrt{2 a} h)^a K_a(\sqrt{2 a}h)}
    The parameter \eqn{a} must be positive.
    This is the model of choice if the smoothness of a random field is to
    be parametrised: if \eqn{a > m} then the
    graph is \eqn{m} times differentiable.

    \item \code{nugget}
    \deqn{C(h)=1_{[0]}(h)}{C(h)=1_[0](h)}

    \item \code{penta}
    \deqn{C(h)= \left(1 - \frac{22}3 h^2 +33 h^4 -
      \frac{77}2 h^5 + \frac{33}2
      h^7 -\frac{11}2 h^9 + \frac 56 h^{11}
      \right)1_{[0,1]}(h)}{C(h)=
      1 - 22/3 h^2 +33 h^4
      - 77/2 h^5 + 33/2 h^7 - 11/2 h^9 + 5/6 h^11  if 0<=h<=1,
      0 otherwise}
    valid only for dimensions less than or equal to 3.
    This is a 4 times differentiable covariance functions with compact
    support.

    \item \code{power}
    \deqn{C(h)= (1-h)^a 1_{[0,1]}(h)}
    This covariance function is valid for 2 dimensions iff
    \eqn{a \ge 1.5}.
    For \eqn{a=1} we get the well-known triangle (or tent)
    model, which is valid on the real line, only.

    \item \code{qexponential}
    \deqn{C(h)= ( 2 e^{-h} - a e^{-2x} ) / ( 2 - a )}
    The parameter \eqn{a} must be in \eqn{[0,1]}.

    \item \code{spherical}
    \deqn{C(h)=\left(1- 1.5 h+0.5 h^3\right) 1_{[0,1]}(h)}{C(h)=
    1 - 1.5 h + 0.5 h^3  if 0<=h<=1, 0 otherwise}
    This  covariance function is valid only for dimensions
    less than or equal to 3.

    \item \code{stable}
    \deqn{C(h)=\exp\left(-h^a\right)}
    The parameter \eqn{a} must be in \eqn{(0,2]}.
    See \code{exponential} and \code{gaussian} for special cases.

    \item \code{wave}
    \deqn{C(h)=\frac{\sin h}{h}, \quad h>0 \qquad \hbox{and } \qquad C(0)=1}{
      C(h)=sin(h)/h if h>0 and C(0)=1}
    This isotropic covariance function is valid only for dimensions less
    than or equal to 3.
    It is a special case of the \code{bessel} model
    (for \eqn{a=0.5}).

    \item \code{whittle}
    \deqn{C(h) = 2^{1-a} \Gamma(a)^{-1} h^a
      K_a(h)}
    The parameter \eqn{a} must be positive.
    This is the model of choice if the smoothness of a random field is to
    be parametrised: if \eqn{a > m} then the
    graph is \eqn{m} times differentiable.

  }

  The default values of the arguments
  \code{mev},
  \code{nugget},
  \code{variance} and \code{scale} are eq 0.

}


\value{
an object of the class \code{covmodel} that defines a covariance model.
}

\author{
Christoph Hofer, \email{christoph.hofer@alumni.ethz.ch}
}

\examples{
# table with all available covariance models and their
# parameters
covmodel()

# exponential model without a measurement error and without a nugget,
# partial sill = 10, scale  parameter = 15
covmodel(modelname = "exponential", variance = 10, scale = 15)

# exponential model with a measurement error ( mev = 0.5) and a
# nugget (nugget = 2.1), exponential partial  sill (variance = 10)
# and scale parameter = 15
covmodel(modelname = "exponential", mev  = 0.5, nugget = 2.1,
variance = 10, scale = 15)
}
%
\keyword{models}

