% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residHelpers.R
\name{steigerStat}
\alias{steigerStat}
\title{steigerStat}
\usage{
steigerStat(myDat, q3Adj = TRUE, fisher = TRUE, dfAdj = FALSE, tpm)
}
\arguments{
\item{myDat}{A data frame or matrix containing standardised residuals.}

\item{q3Adj}{A bool indicating whether the Q3 correction should be applied.}

\item{fisher}{A bool indicating whether the Fisher Transform should be applied.}

\item{dfAdj}{A bool indicating whether the df should be adjusted for sample size, L, and targeting.
If dfAdj is TRUE, then you must pass in the optional argument \code{tmp} (test-person match)}

\item{tpm}{A number indicating the test-person match, where 0 indicates that
mean item difficulty is equal to mean person ability, and -1 indcates that mean item difficulty is 1 logit below mean person ability.}
}
\value{
A list of class "steigerStat" with the Steiger Statistic, correlation matrix, and chi square test.
}
\description{
Function to cacluate the Steiger statistic. The Steiger statistic is a test of independance of
the standardised residuals ((O-E)/sqrt(Var(E))), where Var(E) = p(x)/(1-p(x)).
}
