% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acl.R
\name{acl_add_user}
\alias{acl_add_user}
\alias{acl_add_group}
\alias{acl_add_collaborator}
\alias{acl_add_viewer}
\alias{acl_remove_user}
\alias{acl_add_self}
\alias{acl_remove_self}
\alias{acl_remove_group}
\title{ACL Add Users or Groups}
\usage{
acl_add_user(content, user_guid, role)

acl_add_group(content, group_guid, role)

acl_add_collaborator(content, user_guid)

acl_add_viewer(content, user_guid)

acl_remove_user(content, user_guid)

acl_add_self(content)

acl_remove_self(content)

acl_remove_group(content, group_guid)
}
\arguments{
\item{content}{The R6 Content object (as returned by \code{content_item()})}

\item{user_guid}{The user's GUID. Use \code{get_users()}}

\item{role}{One of "owner" or "viewer"}

\item{group_guid}{The group's GUID. Use \code{get_groups()}}
}
\value{
The R6 content object (for piping)
}
\description{
Add a user or group to the content as an "owner" (collaborator) or "viewer"
}
\details{
\itemize{
\item \code{acl_add_user()} allows you to add ACL for a user and specify role
\item \code{acl_add_group()} allows you to add ACL for a group and specify role
\item \code{acl_add_collaborator()} is a helper to add a \code{user} collaborators
\item \code{acl_add_viewer()} is a helper to add a \code{user} viewer
\item \code{acl_remove_user()} removes a user's ACLs from a piece of content
\item \code{acl_remove_group()} removes a group's ACLs from a piece of content
\item \code{acl_add_self()} is useful for admins and adds the current user as a collaborator
\item \code{acl_remove_self()} removes the current user's ACLs from a piece of content
}
}
\seealso{
Other content functions: 
\code{\link{content_delete}()},
\code{\link{content_item}()},
\code{\link{content_title}()},
\code{\link{content_update}()},
\code{\link{create_random_name}()},
\code{\link{dashboard_url_chr}()},
\code{\link{dashboard_url}()},
\code{\link{delete_vanity_url}()},
\code{\link{deploy_repo}()},
\code{\link{get_acl_user}()},
\code{\link{get_bundles}()},
\code{\link{get_environment}()},
\code{\link{get_image}()},
\code{\link{get_jobs}()},
\code{\link{get_vanity_url}()},
\code{\link{git}},
\code{\link{permissions}},
\code{\link{set_image_path}()},
\code{\link{set_run_as}()},
\code{\link{set_vanity_url}()},
\code{\link{swap_vanity_url}()},
\code{\link{verify_content_name}()}
}
\concept{content functions}
