% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{eval.config.groups}
\alias{eval.config.groups}
\title{Get config file parameter groups}
\usage{
eval.config.groups(file = Sys.getenv("R_CONFIGFILE_ACTIVE", "config.cfg"),
  ...)
}
\arguments{
\item{file}{File name of configuration file to read from. Defaults to the value of
the ‘R_CONFIGFILE_ACTIVE’ environment variable ('config.cfg' if the
variable does not exist and JSON/INI/YAML/TOML format only)}

\item{...}{Arguments for \code{\link{read.config}}}
}
\value{
a character vector including the groups infomation of configure file or
logical FALSE indicating that is not standard JSON/INI/YAML/TOML format file
}
\description{
Get config file parameter groups
}
\examples{
config.json <- system.file('extdata', 'config.json', package='configr')
eval.config.groups(config.json)
}
\seealso{
\code{\link{eval.config.merge}} which use this get all of parameter sets groups of config file.
}
