% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_packages.R
\name{list_packages}
\alias{list_packages}
\title{List Packages Installed in a Conda Environment}
\usage{
list_packages(env_name = "condathis-env", verbose = "silent")
}
\arguments{
\item{env_name}{Character. The name of the Conda environment where the tool will be run. Defaults to \code{"condathis-env"}.
If the specified environment does not exist, it will be created automatically using \code{create_env()}.}

\item{verbose}{Character string specifying the verbosity level of the function's output. Acceptable values are:
\itemize{
\item \strong{"silent"}: Suppress all output from internal command-line tools. Equivalent to \code{FALSE}.
\item \strong{"cmd"}: Print the internal command(s) passed to the command-line tool.
\item \strong{"output"}: Print the standard output and error from the command-line tool to the screen. Note that the order of the standard output and error lines may not be correct, as standard output is typically buffered. If the standard output and/or error is redirected to a file or they are ignored, they will not be echoed.
\item \strong{"full"}: Print both the internal command(s) (\code{"cmd"}) and their standard output and error (\code{"output"}). Equivalent to \code{TRUE}.
Logical values \code{FALSE} and \code{TRUE} are also accepted for backward compatibility but are \emph{soft-deprecated}. Please use \code{"silent"} and \code{"full"} respectively instead.
}}
}
\value{
A tibble containing all the packages installed in the specified environment,
with the following columns:
\describe{
\item{base_url}{The base URL of the package source.}
\item{build_number}{The build number of the package.}
\item{build_string}{The build string describing the package build details.}
\item{channel}{The channel from which the package was installed.}
\item{dist_name}{The distribution name of the package.}
\item{name}{The name of the package.}
\item{platform}{The platform for which the package is built.}
\item{version}{The version of the package.}
}
}
\description{
This function retrieves a list of all packages installed in the specified Conda
environment. The result is returned as a tibble with detailed information about
each package, including its name, version, and source details.
}
\examples{
\dontrun{
condathis::with_sandbox_dir({
  # Creates a Conda environment with the CLI `fastqc`
  condathis::create_env(
    packages = "fastqc",
    env_name = "fastqc-env"
  )
  # Lists the packages in env `fastqc-env`
  dat <- condathis::list_packages("fastqc-env")
  dim(dat)
  #> [1] 34  8
})
}
}
