% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp.R
\name{comp}
\alias{comp}
\alias{hhi}
\alias{hhi_min}
\alias{hhi_d}
\alias{dom}
\alias{sten}
\alias{all_comp}
\title{Concentration Measures}
\usage{
comp(x, unbiased = FALSE, type = c("hhi", "hhi_d", "hhi_min", "dom",
 "sten", "all"),na.rm = TRUE)

hhi(x, unbiased = FALSE, na.rm = TRUE)

hhi_min(x, na.rm = TRUE)

hhi_d(x, na.rm = TRUE)

dom(x, na.rm = TRUE)

sten(x, na.rm = TRUE)

all_comp(x, na.rm = TRUE)
}
\arguments{
\item{x}{A non-negative numeric vector.}

\item{unbiased}{Logical. Argument specifying whether or not a finite sample
correction should be applied. The default is FALSE.}

\item{type}{A character string of the measure to be calculated,
can be abbreviated with the first letter. Defaults to "hhi".}

\item{na.rm}{A logical vector that indicates whether \code{NA} values should
be excluded or not.}
}
\value{
prints the calculated measure
}
\description{
A set of different concentration measures.
}
\details{
\code{comp} is a wrapper for the proposed concentration measures \code{hhi},
\code{hhi_d}, \code{hhi_min}, \code{dom}, \code{sten}, \code{all}.
If no measure is specified "hhi" will be the default.

\code{hhi}, \code{hhi_min}, \code{hhi_d} calculate the Herfindahl-Hirschman
index, its minimum, and its dual, respectively. \code{dom} calculates a
dominance index and \code{sten} calculates the Stenbacka index. The index
indicates the market share of a dominant position.

All measures can be accessed individually.
\code{hhi}, \code{hhi_d}, and \code{dom} can be calculated individually as a
normalized measure changing the default setting to \code{TRUE}. \code{all}
computes all measures in a one step procedure.
}
\note{
the vector of market shares should be in a decimal form corresponding
to total share of individual firms/units. The sum of the vector should sum
up to 1. You can also use sales figures to compute the respective measure.
}
\examples{
# a vector of market shares
x <- c(0.35, 0.4, 0.05, 0.1, 0.06, 0.04)
# the Herfindahl-Hirschmann index of the vector
shares_hhi <- comp(x, type = "hhi")
# individual measure
shares_sten <- sten(x)
# complete group measures
shares_comp <- comp(x, type = "all")

}
\seealso{
{\code{\link{concstats}}, \code{\link{mstruct}},
\code{\link{inequ}}}
}
