% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_local_vocab.R
\name{get_local_vocab}
\alias{get_local_vocab}
\title{Identify words common to a collection of texts and a set of pretrained embeddings.}
\usage{
get_local_vocab(context, pre_trained)
}
\arguments{
\item{context}{(character) vector of contexts (usually \code{context} in \code{get_context()} output)}

\item{pre_trained}{(numeric) a F x D matrix corresponding to pretrained embeddings.
F = number of features and D = embedding dimensions.
rownames(pre_trained) = set of features for which there is a pre-trained embedding.}
}
\value{
(character) vector of words common to the texts and pretrained embeddings.
}
\description{
Local vocab consists of the intersect between the set of pretrained embeddings
and the collection of texts.
}
\examples{
# find local vocab (use it to define the candidate of nearest neighbors)
local_vocab <- get_local_vocab(cr_sample_corpus, pre_trained = cr_glove_subset)
}
\keyword{get_local_vocab}
