% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterComradesMethodsAndHelpers.R
\docType{methods}
\name{trimClusters}
\alias{trimClusters}
\alias{trimClusters,comradesDataSet-method}
\title{trimClusters}
\usage{
trimClusters(clusteredCds, trimFactor = 2.5, clusterCutoff = 1)
}
\arguments{
\item{clusteredCds}{a \code{comradesDataSet} object}

\item{trimFactor}{a positive value that defines how much the clusters will}

\item{clusterCutoff}{Minimum number of reads before discarding cluster
be trimmed = mean + ( sd * trimFactor )}
}
\value{
Returns a \code{comradesDataSet} object
}
\description{
Trimming of the clusters removes redundant information derived from random
fragmentation of the reads during library preparation. This method takes
a \code{comradesDataSet} object where clustering has been performed with 
the clusterCOMRADES method and trims the clusters according to the 
trimFactor argument.
}
\details{
The 3 attributes; matrixList, clusterTableList and clusterGrangesList 
will gain the \code{types} "superClusters" and "trimmedClusters"
}
\examples{
cds = makeExampleComradesDataSet()

clusteredCds = clusterComrades(cds,
                cores = 1,
                stepCount = 1,
                clusterCutoff = 0)
                
trimClusters(clusteredCds = clusteredCds,
             trimFactor = 1, 
             clusterCutoff = 0)
}
