% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate.R
\name{cs_validate}
\alias{cs_validate}
\title{Validate Year List Object}
\usage{
cs_validate(.data, year, verbose = FALSE)
}
\arguments{
\item{.data}{A tbl}

\item{year}{A string representing the year being checked, e.g. \code{"2008" }}

\item{verbose}{A logical scalar. If \code{TRUE}, a full validation report summarizing
results will be returned. If \code{FALSE}, a single value will be returned.}
}
\value{
A tibble with validation results.
}
\description{
Data from SLMPD are released with a number of problems that
    \code{cs_validate} is designed to identify.
}
\details{
\code{cs_validate} performs a total of five checks on the given
    year-list object. Each test is summarized in the \code{verbose = TRUE} output:

\describe{
  \item{valMonth}{Each tibble within a year-list is named for the month it represents.
      Does the named month match the month that the data represent?}
  \item{valYear}{Does the year provided for the \code{year} argument match the year
      that the data represent?}
  \item{oneMonth}{Does each tibble represent only one month of data?}
  \item{varCount}{Does each tibble have the correct number of variables (20)?}
  \item{valVars}{Does each tibble have the correct variable names?}
}

  For all months prior to 2013 and approximately half of the months during 2013,
  SLMPD data are released with 18 variables. For one month, May 2017, the data
  are released with 26 variables. These problems are identified most easily
  by using \code{cs_validate}.
}
\examples{
# load example year-list object
load(system.file("testdata", "yearList17.rda", package = "compstatr", mustWork = TRUE))

# simple validation
cs_validate(yearList17, year = 2017)

# verbose validation
cs_validate(yearList17, year = 2017, verbose = TRUE)

}
