% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zlm.wfit.R
\name{anova.zlm}
\alias{anova.zlm}
\alias{anova.zlmlist}
\title{ANOVA for Complex Linear Fits}
\usage{
\method{anova}{zlm}(object, ...)

\method{anova}{zlmlist}(object, ..., scale = 0, test = "F")
}
\arguments{
\item{object}{objects of class "zlm", usually produced by \link{lm}.}

\item{...}{Other arguments.}

\item{scale}{numeric. An estimate of the noise variance
    \eqn{\sigma^2}. If zero this will be estimated from the
    largest model considered.
  }

\item{test}{a character string specifying the test statistic to be
    used. Can be one of \code{"F"}, \code{"Chisq"} or \code{"Cp"},
    with partial matching allowed, or \code{NULL} for no test.}
}
\value{
An object of class "anova", which inherits from class "data.frame". Contains a analysis of variance table, except for those components that rely on quantiles.
}
\description{
A very simple adaptation of \link[stats:anova.lm]{stats::anova.lm} which can handle fits of complex variables.
The only change was to take the absolute value of squared residuals, and eliminate quantile based features.
Note that this function uses the variance, not the pseudo-variance. An analysis of pseudo-variance (ANOPVA)
is also possible (and maybe useful), but not yet implemented.
}
\details{
Specifying a single object gives a sequential analysis of variance
  table for that fit.  That is, the reductions in the residual sum of
  squares as each term of the formula is added in turn are given in as
  the rows of a table, plus the residual sum of squares.

  The table will contain F statistics (and P values) comparing the
  mean square for the row to the residual mean square.

  If more than one object is specified, the table has a row for the
  residual degrees of freedom and sum of squares for each model.
  For all but the first model, the change in degrees of freedom and sum
  of squares is also given. (This only make statistical sense if the
  models are nested.)  It is conventional to list the models from
  smallest to largest, but this is up to the user.

  Optionally the table can include test statistics.  Normally the
  F statistic is most appropriate, which compares the mean square for a
  row to the residual sum of squares for the largest model considered.
  If \code{scale} is specified chi-squared tests can be used. Mallows'
  \eqn{C_p}{Cp} statistic is the residual sum of squares plus twice the
  estimate of \eqn{\sigma^2}{sigma^2} times the residual degrees of freedom.
}
\section{Functions}{
\itemize{
\item \code{anova.zlmlist}: s3 method for class 'zlmlist'
}}

\examples{
set.seed(4242)
n <- 8
slop <- complex(real = 4.23, imaginary = 2.323)
interc <- complex(real = 1.4, imaginary = 1.804)
err <- complex(real = rnorm(n)/16, imaginary = rnorm(n)/16)
tframe <- data.frame(x= x <- complex(real=rnorm(n), imaginary= rnorm(n)), y=slop*x + interc+err)
fit <- lm(y ~ x, data = tframe, weights = rep(1,n))
anova(fit)
robfit <- rlm(y ~ x, data = tframe)
anova(fit, robfit)
}
\references{
Chambers, J. M. (1992)
  \emph{Linear models.}
  Chapter 4 of \emph{Statistical Models in S}
  eds J. M. Chambers and T. J. Hastie, Wadsworth & Brooks/Cole.
}
\seealso{
\link{lm}, \link{anova}
}
