% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cTransformations.R
\name{clog}
\alias{clog}
\alias{cexp}
\title{Functions that transform real and imaginary parts of a complex variable}
\usage{
clog(y, base = exp(1))

cexp(y, base = exp(1))
}
\arguments{
\item{y}{vector of a complex variable in the original scale.}

\item{base}{a positive or complex number: the base with respect to which
logarithms/powers are computed. Defaults to exp(1).}
}
\value{
A vector of the same size as \code{y}, containing transformed complex variable.
}
\description{
Function \code{clog()} will take logarithm of real and imaginary parts separately
and then merge the resulting variable in the complex one. The function
\code{cexp()} does the opposite transform, taking exponent of parts and then
merging them.
}
\examples{

# Generate random complex variables
y <- complex(real=rnorm(100,100,10), imaginary=rnorm(100,100,10))

yLog <- clog(y)
cexp(yLog)

}
\references{
\itemize{
\item Svetunkov, S. & Svetunkov I. (2022) Complex Autoregressions. In Press.
}
}
\seealso{
\code{\link[complex]{cscale}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{univar}
