% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/results-longcr.R
\name{longcr}
\alias{longcr}
\alias{is_longcr}
\alias{as_longcr}
\alias{as_tibble.longcr}
\title{Long format of competition results}
\usage{
is_longcr(cr_data)

as_longcr(cr_data, repair = TRUE, ...)

\method{as_tibble}{longcr}(x, ...)
}
\arguments{
\item{cr_data}{Data of competition results (convertible to tabular).}

\item{repair}{Whether to repair input.}

\item{...}{Additional arguments to be passed to or from methods.}

\item{x}{Object to be converted to \link[tibble:tibble]{tibble}.}
}
\value{
\code{is_longcr()} returns \code{TRUE} if its argument is appropriate object of
class \code{longcr}: it should inherit classes \code{longcr}, \code{tbl_df} (in other
words, to be \link[tibble:tibble]{tibble}) and have "game", "player", "score"
among column names.

\code{as_longcr()} returns an object of class \code{longcr}.

\link[tibble:as_tibble]{as_tibble()} applied to \code{longcr} object drops \code{longcr}
class.
}
\description{
Functions for dealing with competition results in long format.
}
\details{
\code{as_longcr()} is S3 method for converting data to \code{longcr}. When
using \strong{default} method if \code{repair} is \code{TRUE} it also tries to fix possible
problems (see "Repairing"). If \code{repair} is \code{FALSE} it converts \code{cr_data} to
\link[tibble:tibble]{tibble} and adds \code{longcr} class to it.

When applying \code{as_longcr()} to proper (check via \code{\link[=is_widecr]{is_widecr()}} is made)
\strong{\code{widecr}} object, conversion is made:
\itemize{
\item If there is column \code{game} then it is used as game identifier. Else
treat every row as separate game data.
\item Every "player"-"score" pair for every game is converted to separate row
with adding the appropriate extra columns.
\item Result is arranged by \code{game} and identifier of a "player"-"score" pair
(extra symbols after "player" and "score" strings in input column names) in
increasing order.
\item If \code{repair} is \code{TRUE} then repair is done.
}

For appropriate \strong{\code{longcr}} objects \code{as_longcr()} returns its input and
throws error otherwise.
}
\section{Long format of competition results}{

It is assumed that competition consists from multiple games (matches,
comparisons, etc.). One game can consist from \strong{variable} number of
players. Inside a game all players are treated equally.
In every game every player has some score: the value of arbitrary nature
that fully characterizes player's performance in particular game (in most
cases it is some numeric value).

\code{longcr} inherits from \code{tibble}. Data should have at least three columns with
the following names:
\itemize{
\item \code{game} - game identifier.
\item \code{player} - player identifier.
\item \code{score} - score of particular player in particular game.
}

Extra columns are allowed. \strong{Note} that if object is converted to
\link{widecr}, they will be dropped. So it is better to store
extra information about "game"-"player" pair as list-column "score" which
will stay untouched.
}

\section{Repairing}{

Option \code{repair = TRUE} (default) in \code{as_longcr()} means that its result is
going to be repaired with following actions:
\itemize{
\item Detect columns exactly matching "game", "player" or "score". Those are used
in the output. If all are detected matched columns are put in the beginning.
Other columns are preserved.
\item If not all columns were exactly matched, detect first columns with names
containing "game", "player" or "score" (ignoring case). If there are many
matching names for one output name then the first one is used. In case of
imperfect match, message is given. All other columns are treated as "extra".
\item If some legitimate names aren't detected, respective columns are created
and filled with \code{NA_integer_}. Also a message is given.
\item If in one game some player listed more than once, the first record is
taken.
\item Return the tibble with at least 3 appropriate for \code{longcr} columns and
column names.
}
}

\examples{
# Repairing example
cr_data <- data.frame(
  playerscoregame_ID = rep(1:5, times = 2),
  gameId = rep(1:5, each = 2),
  scoreS = 31:40,
  scoreSS = 41:50
)
cr_data_long <- as_longcr(cr_data, repair = TRUE)

is_longcr(cr_data_long)

as_tibble(cr_data_long)
}
\seealso{
\link[=widecr]{Wide format}
}
