% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{LossBinomial}
\alias{LossBinomial}
\title{0-1 Loss for binary classification derived of the binomial distribution}
\format{\code{\link{S4}} object.}
\description{
This loss can be used for binary classification. The coding we have chosen
here acts on
\eqn{y \in \{-1, 1\}}.
}
\details{
\strong{Loss Function:}
\deqn{
  L(y, f(x)) = \log(1 + \mathrm{exp}(-2yf(x)))
}
\strong{Gradient:}
\deqn{
  \frac{\delta}{\delta f(x)}\ L(y, f(x)) = - \frac{y}{1 + \mathrm{exp}(2yf)}
}
\strong{Initialization:}
\deqn{
  \hat{f}^{[0]}(x) = \frac{1}{2}\mathrm{log}(p / (1 - p))
}
with
\deqn{
  p = \frac{1}{n}\sum\limits_{i=1}^n\mathrm{1}_{\{y^{(i)} = 1\}}
}
}
\section{Usage}{

\preformatted{
LossBinomial$new()
LossBinomial$new(offset)
}
}

\section{Arguments}{

\describe{
\item{\code{offset} [\code{numeric(1)}]}{
  Numerical value which can be used to set a custom offset. If so, this
  value is returned instead of the loss optimal initialization.
}
}
}

\section{Details}{


  This class is a wrapper around the pure \code{C++} implementation. To see
  the functionality of the \code{C++} class visit
  \url{https://schalkdaniel.github.io/compboost/cpp_man/html/classloss_1_1_binomial_loss.html}.
}

\examples{

# Create new loss object:
bin.loss = LossBinomial$new()
bin.loss

}
