% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StringComparator.R
\docType{class}
\name{StringComparator-class}
\alias{StringComparator-class}
\title{Virtual String Comparator Class}
\description{
Represents a comparator for pairs of strings.
}
\section{Slots}{

\describe{
\item{\code{.Data}}{a function that calls the elementwise method for this class,
with arguments \code{x}, \code{y} and \code{...}.}

\item{\code{symmetric}}{a logical of length 1. If TRUE, the comparator is symmetric
in its arguments---i.e. \code{comparator(x, y)} is identical to
\code{comparator(y, x)}.}

\item{\code{distance}}{a logical of length 1. If \code{TRUE}, the comparator produces
distances and satisfies \code{comparator(x, x) = 0}. The comparator may not
satisfy all of the properties of a distance metric.}

\item{\code{similarity}}{a logical of length 1. If \code{TRUE}, the comparator produces
similarity scores.}

\item{\code{tri_inequal}}{a logical of length 1. If \code{TRUE}, the comparator satisfies
the triangle inequality. This is only possible (but not guaranteed) if
\code{distance = TRUE} and \code{symmetric = TRUE}.}

\item{\code{ignore_case}}{a logical of length 1. If TRUE, case is ignored when
comparing strings. Defaults to FALSE.}

\item{\code{use_bytes}}{a logical of length 1. If TRUE, strings are compared
byte-by-byte rather than character-by-character.}
}}

